/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file MiniTLS.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef MINITLS_CPP_H_
#define MINITLS_CPP_H_

class TLSSocket;

#include "core/fwk.h"
#include "tls/minitls.h"
#include "crypto/crypto_prng.h"

#include "inc/minitls_errors.h"

/** MiniTLS library
 *
 */
class MiniTLS
{
public:
  MiniTLS();
  ~MiniTLS();

  void init();

  void feedPRNG(uint8_t* buffer, size_t length);

  minitls_err_t addCertificate(const uint8_t* cert, size_t certSize, const uint8_t* pubKey, size_t pubKeySize);

private:
  crypto_prng_t m_prng;
  minitls_t m_minitls;
  tls_x509_certificate_t m_cert;

  friend class TLSSocket;
};


#endif /* MINITLS_CPP_H_ */
