#include "mbed.h"
#include "rtos.h"
#include "sysinterface.h"
#include "WiflyInterface.h"
#include "HTTPClient.h"
#include "C12832.h"
//Serial console(USBTX, USBRX); // Primary output to demonstrate library
// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);

/* wifly interface:
*     - D1 is for the serial communication, Tx
*     - D0 is for the serial communication, Rx
*     - D3 is for the reset pin
*     - D2 is for the connection status
*     - "AndroidAP11" is the ssid of the network
*     - "" is the password
*     - NONE is the security (or WPA)
*/
WiflyInterface wifly(D1, D0, D3, D2, "WIFITest", "54510000", WPA);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
HTTPClient http;
char str[512];
int main()
{

    // Setup

    // Diagnostic printing of K64F
    printf("\r\n\nmbed K64F !\r\n");

    lcd.cls();

    lcd.printf( "Start to initialise Wi-Fi!\n" );

    int s = wifly.init(); //Use DHCP

    if( s != NULL )
    {
        lcd.printf( "Could not initialise. Will halt!\n" );
        exit( 0 );
    }

    lcd.printf( "Start to connect Wi-Fi!\n" );

    while(!wifly.connect())
     ;

        
    lcd.printf( "IP: %s\n", wifly.getIPAddress() );
    wait( 2.0 );
    lcd.cls();

    //GET data
    printf("Trying to fetch page...\r\n");  
        net_system_start;
    int ret = http.get("http://httpbin.org/ip", str, 128);
    if (!ret) {
        printf("Page fetched successfully - read %d characters\r\n", strlen(str));
        printf("Result: %s\r\n", str);
        lcd.printf( "GET: %d OK\n", strlen(str));
    } else {
        printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
        lcd.printf( "GET: ERROR %d !\n", http.getHTTPResponseCode());
    }

    //POST dataGet
    HTTPMap map;
    HTTPText text(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("Trying to post data...\r\n");
    ret = http.post("http://httpbin.org/post", map, &text);
    if (!ret) {
        printf("Executed POST successfully - read %d characters\r\n", strlen(str));
        printf("Result: %s\r\n", str);
        lcd.printf( "PUT: %d OK\n", strlen(str));
    } else {
        printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
        lcd.printf( "PUT: ERROR %d !\n", http.getHTTPResponseCode());
    }

    wifly.disconnect();

    lcd.printf( "Start to disconnect Wi-Fi!\n" );

    while (true) {
      wait( 1.0 );
      //lcd.printf(".");
    }
}
