#include <algorithm>
#include "baseinterface.h"

Wifly*wifi;
/********************************************
*function:wifi get instance
*
********************************************/
bool base_level_getinstance(void)
{
    wifi=Wifly::getInstance();
    if (wifi == NULL)
            return 0;
        return 1;
}

/***********************************
*function: wifi close
* 
**********************************/
bool base_level_close()
{
    return (wifi->close())?0:-1;
}

/*************************
*function:wifi connect
*
************************/
bool base_level_connect(const char* host, const int port)
{
    if(!wifi->connect(host,port))
        return -1;
    wifi->flush();
            return 0;
}

/*******************************
*function:if wifi is connected?
*
*********************************/
bool base_level_is_connected(void)
{
    return wifi->is_connected();
}

/*****************************
*function:wifi send_data
*
******************************/
int baselevel_send_data(char *data,int length)
{
        int idx =0;
        idx +=wifi->send(data, length);
      return idx;
}

/********************************
*function:receive_data
*
* 
********************************/
int baselevel_receive_data(char *data,int length)
{
     //while(!wifi->readable());
int idx=0;
    int nb_available = wifi->readable();
      for (int i = 0; i < min(nb_available, length); i++) {
       data[idx++] = wifi->getc();
            }   
        return idx;
}
/****************************************
*function:wifi->readable()
*
*****************************************/
int  baselevel_is_readable()
{
        int nb_available=wifi->readable();
    
        return nb_available;
}
