/**************************************
*file :TcpServer test
*Creator:JacobShi
*Time:2014/10/29
* Description:make the mbed become a server
* and receive the data from the client
* send the data to the screen.
* confirm the server ip is 192.168.1.101
***************************************/
#include "mbed.h"
#include "EthernetInterface.h"
EthernetInterface eth;
#define  PORT  8080
char databuffer[100];
int main(void)
{
    eth.init("192.168.1.101","225.225.225.0","192.168.1.1");
    eth.connect();
    printf("the ip address of the mbed is :%s\n",eth.getIPAddress());
    
    TCPSocketServer server;
    TCPSocketConnection client;
    server.bind(PORT);
    server.listen();
    server.accept(client);
    client.set_blocking(true,NULL);
    printf("the ip addr of the client is :%s\n",client.get_address() );
    
    while(1)
    {
       int n=client.receive(databuffer,sizeof(databuffer));
       if(n<=0)
        break;
        client.send_all("receive OK",sizeof("receive OK"));
       printf("the receive data is :\n");
             for(int i=0;i<n;i++)
             {
                printf("%c\n",databuffer[i]);
            }

    }
    client.close();
}
