/***************************************************
*file:broadcast receive
*Creator:JacobShi
*Time:2014/10/30
*Description:receive the data from the source and
* turn the data back
 *******************************************************/

#include "mbed.h"
#include "EthernetInterface.h"
 
const int BROADCAST_PORT = 8080;
 
int main() {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    
    UDPSocket socket;
    socket.bind(BROADCAST_PORT);
    socket.set_broadcasting();
    
    Endpoint broadcaster;
    char buffer[256];
    while (true) {
        int n = socket.receiveFrom(broadcaster, buffer, sizeof(buffer));
        buffer[n] = '\0';
        socket.sendTo(broadcaster,buffer,sizeof(buffer));
        
    }
}