//クラス宣言は最初の文字だけ大文字で
//足周りは反時計回りに0～3
//エンコーダーで呼んだ値をcmに変換
#include "mbed.h"
#include "SBDBT.h"
#include "BNO055.h"
#include "YKNCT_I2C.h"
#include "movement.h"
#define PI 3.14159265359   //円周率
#define DEG_TO_DIS(x) PI*LEG*(x/360)
#define DEG_TO_RAD(x) ((x)*M_PI / 180.0)
#define RAD_TO_DEG(x) ((x)*180.0 / M_PI)
#define LEG 50.8 //odometar オムニ
#define Kp 0.4 //p制御用定数
#define Ki 30 //i制御用定数
#define death 2
//pcとの通信
Serial Pc(USBTX,USBRX,9600);
Timer t;
//コントローラーとの接続
double LX,LY,RX;//コントローラー
SBDBT Sbdbt(PA_0,PA_1,9600);
//i2cとMD
Y_I2C I2c(PB_4,PA_8);//sda scl
MD_I2C_Data_TypeDef MD_Data[]= {
    {8,0,0,0,{0}},//足0
    {9,0,0,0,{0}},//足1
    {10,0,0,0,{0}},//足2
    {11,0,0,0,{0}},//足3
};
Timer re_i2c;
//ジャイロ
double yaw=0.0;
double taryaw=0.0;
BNO055 Gyro(PB_9,PB_8,&yaw);
Timer yawCnt;
//エンコーダー
double deg[2]= {0};
double diff[2][2]= {0};
int encoder[2]= {0};
Ticker Encoder;
DigitalOut Cs(PA_6);
DigitalOut Clk(PA_7);
DigitalIn Do[]= {PB_6,PB_0};
double dis[2]= {0};
//リミットスイッチ
DigitalIn Switch[]= {PC_8,PC_6};
//PID制御
//コントローラ
double x=0;//Lx
double y=0;//Ly
//i制御
int point_x=0;
int point_y=0;
int add_x=0;
int add_y=0;
//自動
static int mode_flag=0;//0:手動 1:自動
int arrival_flag=0;

/*enum*/
typedef enum {
    LEG0_MOTOR,
    LEG1_MOTOR,
    LEG2_MOTOR,
    LEG3_MOTOR,

    MOTOR_NUM
} _MOTOR_;

typedef enum {
    LEGX_DEG,
    LEGY_DEG,

    ENCODER_NUM //エンコーダーの数
} _ENCODER_;

typedef enum {
    NOW,
    PAST,

    TIME_NUM
} _TIME_;

/*変数*/
//データチェック
int data_type=0;
//モーター
int pwm[MOTOR_NUM]= {0};//足回り
//座標
struct Coordinate { //座標
    double x,y,rad;
};
//自動制御座標番号
int num=0;
Coordinate curent= {0,0,0}; //現在座標
Coordinate dev[2]= { //偏差座標
    {0,0,0},
    {0,0,0},
};
Coordinate target[100]= { //目標座標
    {0,0,0},
    {100,0,0},
    {100,100,0},//yへ100mm前進
    {0,100,0},
    {0,0,0},//4
    {0,0,0},
    {0,0,0},
    {0,0,0},
    {0,0,0},
    {0,0,0},//8
};
Coordinate origin= {0,0,0}; //原点座標

//関数
void auto_move(Coordinate curent,Coordinate target[],int i);
void auto_move(Coordinate curent,Coordinate target[],int *i);
/******************************************
・各値をシリアル通信でpcに出力
・出力される値は引数による
一番端は時間（秒）
0_足回りのpwm
1_コントローラーの値 左右ステック
2_エンコーダーx,y
default_0と位置
******************************************/
void setup()
{
    deg[0]=0;
    deg[1]=0;
    yaw=0;
}
void data_check(int p)
{
    switch(p) {
        case 0://pwm
            Pc.printf("%0.0f  ",t.read());
            for(int i=LEG0_MOTOR; i<=LEG3_MOTOR; i++) Pc.printf("pwm[%d] %d ",i,pwm[i]);
            break;
        case 1://コントローラー
            Pc.printf("%0.0f  ",t.read());
            Pc.printf("LY %0.0f  LX %0.0f RX %0.0f",LY,LX,RX);
            break;
        case 2://位置情報
            Pc.printf("%0.0f  ",t.read());
            Pc.printf("mode %d %d ",mode_flag,num);
            Pc.printf("X %0.0f  Y %0.0f R %0.0f",curent.x,curent.y,curent.rad);

            break;
        case 3://積分point
            Pc.printf("%0.0f  ",t.read());
            Pc.printf("mode %d %d ",mode_flag,num);
            Pc.printf("point_x %d point_y %d",point_x,point_y);
            for(int i=LEG0_MOTOR; i<=LEG3_MOTOR; i++) Pc.printf("pwm[%d] %d ",i,pwm[i]);

            break;

        case 4:
            Pc.printf("%0.0f  ",t.read());
            Pc.printf("mode %d %d ",mode_flag,num);
            Pc.printf("point_x %d point_y %d  x %0.0f  y %0.0f",point_x,point_y,x,y);
            break;

        default:
            Pc.printf("%0.0f  ",t.read());
            Pc.printf("data_type %d",data_type);
    }
    Pc.printf("\n\r");
}

/******************************************
・コントローラーの値を調整する
・引数の値がコントローラーの最大値となる．．．はず
******************************************/
void con_adjust(int max)//制限
{
    if (Sbdbt.LX <= 64) LX = (Sbdbt.LX - 64) * max / 64;
    else if (Sbdbt.LX > 64) LX = (Sbdbt.LX - 64) * max / 63;
    if (Sbdbt.LY <= 64) LY = (Sbdbt.LY - 64) * max / 64 * -1;
    else if (Sbdbt.LY > 64) LY = (Sbdbt.LY - 64) * max / 63 * -1;
    if (Sbdbt.RX <= 64) RX = (Sbdbt.RX - 64) * max / 64;
    else if (Sbdbt.RX > 64) RX = (Sbdbt.RX - 64) * max / 63;
}

/******************************************
・エンコーダーの値を取得する
・deg[]に入る
******************************************/
void EncodersRead()
{
    int rev[ENCODER_NUM]= {0};
    static int cnt = 0;
    static int data[ENCODER_NUM]= {0};
    static int flag=0;

    if (cnt % 2 == 0) {
        if (cnt == 0) {
            Cs = 0; //データの送信をスタート
            for (int i=0; i<ENCODER_NUM; i++) data[i] = 0;
        }
        Clk = 1; //Doに1bitはいる
    } else {
        //Doにデータが来てないので1回待つ
        if (cnt != 1) for(int i=0; i<ENCODER_NUM; i++) data[i] |= Do[i];
        if (cnt != 25) {
            for(int i=0; i<ENCODER_NUM; i++) data[i]<<=1;
            Clk = 0; //データの送信をスタート
        } else {
            for(int i=0; i<ENCODER_NUM; i++) {
                encoder[i] = data[i] * 360 / 4096; //最大値が4096だから
            }
            Cs = 1; //データの送信を一区切り

            /*蓄積値*/
            if(flag==0) {//一回目は同じ値にする
                for(int i=0; i<ENCODER_NUM; i++) {
                    diff[i][0]=360*rev[i]+encoder[i];
                    diff[i][1]=360*rev[i]+encoder[i];
                }
                flag=1;
            }
            for(int i=0; i<ENCODER_NUM; i++) {
                if(diff[i][1]!=360*rev[i]+encoder[i]) {
                    diff[i][0]=diff[i][1];
                    diff[i][1]=360*rev[i]+encoder[i];
                }
            }
            for(int i=0; i<ENCODER_NUM; i++) {
                if(diff[i][0]==0&&diff[i][1]==359) deg[i]--;
                else if(diff[i][0]==359&&diff[i][1]==0) deg[i]++;
                else deg[i]+=diff[i][1]-diff[i][0];
                diff[i][0]=diff[i][1];
            }
        }
    }
    for(int i=0; i<ENCODER_NUM; i++) if(encoder[i]==0) rev[i]++;
    cnt++;
    cnt %=26;
}

/******************************************
・各モーターのpwmを出力する
******************************************/
void motor_drive()
{
    int over=50;
    //オーバーチェック
    for(int i=0; i<MOTOR_NUM; i++) {
        if(pwm[i]>over) pwm[i]=over;
        else if(pwm[i]<-1*over) pwm[i]=-1*over;
    }

    for(int i=0; i<MOTOR_NUM; i++) {
        if(pwm[i]>0) MD_SET_DRIVE(MD_Data,i,MD_FORWARD);//正
        else if(pwm[i]<0) MD_SET_DRIVE(MD_Data,i,MD_REVERSE);//逆
        else MD_SET_DRIVE(MD_Data,i,MD_BRAKE);//止
        MD_SET_PWM(MD_Data,i,abs(pwm[i]));
        I2c.MD_I2C(MD_Data,i);
    }
}

/******************************************
・コントローラーのLX,LY,RXから4輪オムニの足回りのPWMを出力する
・コントローラーの〇でジャイロを初期化
・corを倍にすると補正も大きくなる
U字に左上から0,1,2,3
0   y    3

         x

1        2
******************************************/
void omuni()
{
    if(Sbdbt.RX!=64) yawCnt.reset(); //もとに戻る用にする
    if(yawCnt.read_ms()<1000) taryaw=yaw;//目標の角度（yaw）を取得  基準を新しくする  １秒待ってもとに戻る

    double cor=taryaw-yaw;


    pwm[0] = LX * cos(DEG_TO_RAD(yaw) + M_PI / 4) +
             LY * sin(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[1] = -LX * sin(DEG_TO_RAD(yaw) + M_PI / 4) +
             LY * cos(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[2] = -LX * cos(DEG_TO_RAD(yaw) + M_PI / 4) -
             LY * sin(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[3] = LX * sin(DEG_TO_RAD(yaw) + M_PI / 4) -
             LY * cos(DEG_TO_RAD(yaw) + M_PI / 4);

    for(int i=LEG0_MOTOR; i<=LEG3_MOTOR; i++) {
        pwm[i]+=RX;//旋回
        pwm[i]-=cor;//補正
    }
}
/******************************************
・現在値を代入
******************************************/
void position_update()
{
//    curent.x=-curent.rad*cos(DEG_TO_RAD(curent.rad))-curent.rad*sin(DEG_TO_RAD(curent.rad));
//    curent.y=-curent.rad*sin(DEG_TO_RAD(curent.rad))+curent.rad*cos(DEG_TO_RAD(curent.rad));
    curent.x=DEG_TO_DIS(deg[1]);
    curent.y=DEG_TO_DIS(deg[0]);
//    curent.x=deg[1];
//    curent.y=deg[0];
    curent.rad=yaw;
}
/******************************************
・座標比較
・同じなら0違うなら1
******************************************/
int coord_compa(Coordinate a,Coordinate b)
{
    if(a.x==b.x&&a.y==b.y&&a.rad==b.rad) return 0;
    else return 1;
}

int coord_compa(Coordinate a,Coordinate b,int all)
{
    if(abs(a.x-b.x)<all&&abs(a.y-b.y)<all&&abs(a.rad-b.rad)<all) return 0;
    else return 1;
}

void naka()
{
    static double pa;
    static double pb;

    pb=(LY-LX)/2;
    pa=LX+pb;
    pwm[0]=-pa;
    pwm[3]=pb;
    pwm[1]=-pb;
    pwm[2]=pa;
    Pc.printf("%0.0f %0.0f \n\r ",pa,pb);
}



/******************************************
・コマンド
・〇＿ジャイロ初期化
・△＿エンコーダー初期化
・□＿積分ポイント初期化
******************************************/
void command()
{
    static bool pushFlag=0;
    if(Sbdbt.CIRCLE||Sbdbt.TRIANGLE||
            Sbdbt.SQUARE||Sbdbt.CROSS||Sbdbt.LEFTkey||Sbdbt.RIGHTkey) {
        if(pushFlag==0) {
            pushFlag=1;
            if(Sbdbt.CIRCLE) {
                taryaw=0;
                yaw=0;
            } else if(Sbdbt.TRIANGLE) {
                deg[0]=0;
                deg[1]=0;
            } else if(Sbdbt.SQUARE) {
                point_x=0;
                point_y=0;
            } else if(Sbdbt.CROSS) {
                data_type=0;
            } else if(Sbdbt.LEFTkey) {
                data_type--;
            } else if(Sbdbt.RIGHTkey) {
                data_type++;
            }
        }
    } else pushFlag=0;
}
/******************************************
・現在座標と目標座標から足回りのオムニのPWMを出力
・現在は4輪オムニだけ
******************************************/
void auto_move(Coordinate curent,Coordinate target[],int *i)
{
    if(coord_compa(curent,target[*i],2)) {
        //比例動作
        x=Kp*(target[*i].x-curent.x);
        y=Kp*(target[*i].y-curent.y);
        //積分動作
        //偏差値の更新
        dev[PAST]=dev[NOW];
        dev[NOW].x=target[*i].x-curent.x;
        dev[NOW].y=target[*i].y-curent.y;
        dev[NOW].rad=target[*i].rad-curent.rad;

        if(coord_compa(dev[NOW],origin)) { //偏差が存在していたら
            if(dev[NOW].x>0) point_x+=1;//正方向
            else if(dev[NOW].x<0) point_x-=1;//負方向

            if(dev[NOW].y>0) point_y+=1;
            else if(dev[NOW].y<0) point_y-=1;
        }
        x+=point_x;
        y+=point_y;
    } else *i++;//着いたら


    pwm[0] = x* cos(DEG_TO_RAD(yaw) + M_PI / 4) +
             y * sin(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[1] = -x * sin(DEG_TO_RAD(yaw) + M_PI / 4) +
             y * cos(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[2] = -x * cos(DEG_TO_RAD(yaw) + M_PI / 4) -
             y * sin(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[3] = x * sin(DEG_TO_RAD(yaw) + M_PI / 4) -
             y * cos(DEG_TO_RAD(yaw) + M_PI / 4);
}
void auto_move(Coordinate curent,Coordinate target[],int i) //現在座標 i➝どの座標
{
    // //到着判定
//    if(coord_compa(curent,target[i])) {
//        arrival_flag=1;
//    }else arrival_flag=0;

    //比例動作
    x=Kp*(target[i].x-curent.x);
    y=Kp*(target[i].y-curent.y);
    //積分動作
    //偏差値の更新
    dev[PAST]=dev[NOW];
    dev[NOW].x=target[i].x-curent.x;
    dev[NOW].y=target[i].y-curent.y;
    dev[NOW].rad=target[i].rad-curent.rad;

    if(coord_compa(dev[NOW],origin)) { //偏差が存在していたら
        if(dev[NOW].x>0) point_x+=1;//正方向
        else if(dev[NOW].x<0) point_x-=1;//負方向

        if(dev[NOW].y>0) point_y+=1;
        else if(dev[NOW].y<0) point_y-=1;
    }
    x+=point_x;
    y+=point_y;

    pwm[0] = x* cos(DEG_TO_RAD(yaw) + M_PI / 4) +
             y * sin(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[1] = -x * sin(DEG_TO_RAD(yaw) + M_PI / 4) +
             y * cos(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[2] = -x * cos(DEG_TO_RAD(yaw) + M_PI / 4) -
             y * sin(DEG_TO_RAD(yaw) + M_PI / 4);
    pwm[3] = x * sin(DEG_TO_RAD(yaw) + M_PI / 4) -
             y * cos(DEG_TO_RAD(yaw) + M_PI / 4);

    if(yawCnt.read_ms()<1000) taryaw=yaw;//目標の角度（yaw）を取得  基準を新しくする  １秒待ってもとに戻る

    double cor=taryaw-yaw;

    for(int i=LEG0_MOTOR; i<=LEG3_MOTOR; i++) {
        pwm[i]-=cor;//補正
    }
}
/******************************************
・コントローラーのR1で自動モード
L1で手動モード
******************************************/
void switch_move()
{
    //選択コマンド
    static bool pushFlag=0;
    if(Sbdbt.UPkey==1||Sbdbt.DOWNkey==1) {
        if(pushFlag==0) {
            pushFlag=1;
            if(Sbdbt.UPkey)num++;
            else if(Sbdbt.DOWNkey)num--;
        }
    } else {
        pushFlag=0;
    }
    if(Sbdbt.R1==1) mode_flag=1;
    else if(Sbdbt.L1==1) mode_flag=0;
    if(mode_flag==1) {
//        auto_move(curent,target,num);
        auto_move(curent,target,&num);//目標座標自動変更
    } else omuni();
}
