#include "entete.h"

#include "AX12/AX12.h"
#include "ControlleurPince/ControlleurPince.h"

DigitalIn CAMP(PA_15);
DigitalIn START(PB_7);
DigitalOut LEDR(PC_2);
DigitalOut LEDV(PC_3);
DigitalIn button(USER_BUTTON);
int SCouleur = VERT;

BusOut drapeau (PC_8, PC_6, PC_5);
RoboClaw roboclaw(ADR, 460800, PA_11, PA_12);
DigitalIn start(PB_7);

AX12 Parasol(PA_9, PA_10, 2, 250000);

/* Sharps */
AnalogIn Rcapt1(PA_4);
int RvalRcapt1 = 0;
AnalogIn Rcapt2(PB_0);
int RvalRcapt2 = 0;
AnalogIn Rcapt3(PC_1);
int RvalRcapt3 = 0;
int Ravance = 1;
float R_SEUIL_SHARP = 1;

/* Pour la pince */
AX12 left_hand(PA_9, PA_10, 3, 250000);
AX12 right_hand(PA_9, PA_10, 1, 250000);
Stepper RMot(NC, PA_8, PC_7, PB_15, 4);
Stepper ZMot(NC, PB_4, PB_10, PB_14, 5);
Stepper LMot(NC, PB_5, PB_3, PB_13, 4);
DigitalIn EnR(PB_15);
DigitalIn EnZ(PB_14);
DigitalIn EnL(PB_13);

ControlleurPince controlleurPince(RMot, ZMot, LMot, EnR, EnZ, EnL,left_hand,right_hand);

/* Debut du programme */
int main(void)
{
    Ticker ticker;
    Timeout end;
    
    ticker.attach(&Sharps, 0.01);
    
    init_globals();
    
    if (SCouleur == VERT) {
        end.attach(&endFonc, 90);
        GotoDist(9.0);
        GotoArr(9.2);
        R_SEUIL_SHARP = 0.25;
        GotoDist(2.5);
        GotoThet(-3.04);
        R_SEUIL_SHARP = 0.35;
        GotoDist(5.5);
        R_SEUIL_SHARP = 1;
        GotoDist(4.5);
        GotoArr(3);
        R_SEUIL_SHARP = 0.35;
        GotoThet(3.04);
        GotoDist(3.5);
        GotoThet(-3.04);
        R_SEUIL_SHARP = 1; 
        GotoDist(4.6);
    }
    else if (SCouleur == VIOLET) {  
        end.attach(&endFonc, 90);
        GotoDist(9.0);
        GotoArr(9.2);
        R_SEUIL_SHARP = 0.25;
        GotoDist(2.5);
        GotoThet(3.04);
        R_SEUIL_SHARP = 0.35;
        GotoDist(5.5);
        R_SEUIL_SHARP = 1;
        GotoDist(4.5);
        GotoArr(4);
        R_SEUIL_SHARP = 0.35;
        GotoThet(-3.04);
        GotoDist(3.5);
        GotoThet(3.04);
        R_SEUIL_SHARP = 1; 
        GotoDist(4.6);
    }
    else if (SCouleur == NOIR) {
        end.attach(&endFonc, 90);
        GotoDist(9.0);
    }

    while(1);
}

void Sharps() {
    if (Rcapt1.read() > R_SEUIL_SHARP) RvalRcapt1++;
    else RvalRcapt1--;
    RvalRcapt1 = RvalRcapt1 > 10 ? 10 : RvalRcapt1;
    RvalRcapt1 = RvalRcapt1 < 0 ? 0 : RvalRcapt1;
    
    if (Rcapt2.read() > R_SEUIL_SHARP) RvalRcapt2++;
    else RvalRcapt2--;
    RvalRcapt2 = RvalRcapt2 > 10 ? 10 : RvalRcapt2;
    RvalRcapt2 = RvalRcapt2 < 0 ? 0 : RvalRcapt2;
    
    if (Rcapt3.read() > R_SEUIL_SHARP) RvalRcapt3++;
    else RvalRcapt3--;
    RvalRcapt3 = RvalRcapt3 > 10 ? 10 : RvalRcapt3;
    RvalRcapt3 = RvalRcapt3 < 0 ? 0 : RvalRcapt3;
    
    if ((RvalRcapt1 >= 5 || RvalRcapt2 >= 5 || RvalRcapt3 >= 5))
        Ravance = 0;
    else 
        Ravance = 1;
        
    if (Ravance == 0)
        drapeau = 1;
    else 
        drapeau = 2;
}

void endFonc () {
    roboclaw.ForwardM1(0);
    roboclaw.ForwardM2(0);
    wait(1);
    Parasol.setMaxTorque(1000);
    wait(1);
    Parasol.setGoal(300);
    while(1);
}

void init_globals() {
    roboclaw.ForwardM1(0);
    roboclaw.ForwardM2(0);

    Parasol.setMode(0);
    Parasol.setMaxTorque(200);
    Parasol.setGoal(150);
    wait(1);
    Parasol.setGoal(160);
    wait(1);
    Parasol.setGoal(150);
    wait(1);
    Parasol.setMaxTorque(0);
    
    while(START == 1)
    {
        LEDR = 1;
        LEDV = 1;
        wait(0.5);
        LEDR = 0;
        LEDV = 0;
        wait(0.5);
    }
   
    wait(1);
    depart();
}
