#ifndef MAP_H
#define MAP_H

/* Dernier Changement : Romain 20h30 
Inclu dans : main.cpp 
Il faut encore gerer les formations de coquillage */

#include "obsCarr.h"
#include "pointParcours.h"
#include "nVector.h"
#include "controle.h"
#include "Objectif/objectif.h"
#include "../Odometry/Odometry.h"
#include "../AX12/AX12.h"
#include "../../StepperMotor/Stepper.h"

#define MAP_RIGHTSIDE 1
#define MAP_LEFTSIDE 2

class map {
public:
    map (Odometry* nodo, AX12 * nA1, AX12 * nA2, AX12 * nA3, Stepper * nS1, Stepper * nS2);
    void addObs (obsCarr nobs);
    void FindWay (point dep, point arr);
    void FindWay (float depX, float depY, float arrX, float arrY);
    void Execute (int obj);
    void Execute (float XObjectif, float YObjectif);
    void Build(int couleur, int formation);
    nVector<pointParcours>& getParc () { return path; }
    bool& getEnded () { return endedParc; }

protected:
    nVector<obsCarr> obs;
    nVector<pointParcours> path;
    nVector<Objectif> objectifs;

    bool endedParc; // Definit s'il existe un chemin parcourable dans le dernier FindWay
    Odometry* Codo;
    AX12 * A1, * A2, * A3;
    Stepper * S1, * S2;

    float min_x_table, min_y_table, max_x_table, max_y_table;
};

#endif