#include "map.h"

/* Dernier Changement : Romain 20h30 */

map::map (Odometry* nodo) : Codo(nodo) {
}

void map::Build (int couleur, int formation) {
    if (couleur == VERT) {
        max_x_table = 2800;
        max_y_table = 1800;
        min_x_table = 0;
        min_y_table = 0;
    }

    addObs(obsCarr (800, 100, 100, 15));
    addObs(obsCarr (2200, 100, 100, 15));
    
    addObs(obsCarr (1500, 750, 1100, 15));
    addObs(obsCarr (1500, 1050, 20, 300));
    
    if (formation == 1) { 
        addObs(obsCarr (0, 2000, 250, 150));  // Coté haut droite
        addObs(obsCarr (200, 2000, 200, 50));
        
        addObs(obsCarr (3000, 2000, 250, 150));     // Coté bas droite
        addObs(obsCarr (2800, 2000, 200, 50));
        
        addObs(obsCarr (200, 2000-450, 40, 40));   // Coquillages du haut droit
        addObs(obsCarr (200, 2000-750, 40, 40));
        
        addObs(obsCarr (900, 2000-550, 40, 40));
        addObs(obsCarr (1200, 2000-350, 40, 40)); // Coquillages du milieu/haut
        
        addObs(obsCarr (1500, 2000-550, 40, 40));
        addObs(obsCarr (1500, 2000-350, 40, 40)); 
        
        addObs(obsCarr (3000-900, 2000-550, 40, 40));
        addObs(obsCarr (3000-1200, 2000-350, 40, 40));   
        
        addObs(obsCarr (3000-200, 2000-450, 40, 40));   // Coquillages du bas droite
        addObs(obsCarr (3000-200, 2000-750, 40, 40));
    }
    else {
        addObs(obsCarr (1250, 1000, 220, 220));
        addObs(obsCarr (1500, 750, 220, 220));
        addObs(obsCarr (1500, 1250, 220, 220));   
    }
}

void map::addObs (obsCarr nobs) {
    obs.push_back (nobs);
}

void map::FindWay (float depX, float depY, float arrX, float arrY) {
    point depart(depX, depY);
    point arrivee(arrX, arrY);
    FindWay(depart, arrivee);
}

void map::FindWay (point dep, point arr) {
    //logger.printf("On a cherche un chemin\n\r");
    nVector<pointParcours> open;
    nVector<pointParcours> close;
    points4 tmp;
    bool val[4] = {true,true,true,true};
    int os = obs.size ();
    int i, j;
    bool ended=false;   // On teste tous les points ajoutes dans l'open list pour savoir s'il y a intersection avec un obstacle. Ended passe à true quand aucun ne coupe un obstacle.
    endedParc = false;

    path.clear();
    
    pointParcours depP (dep, NULL, arr);
    int indTMP1=0;  // Le point actuel
    int PointEnding = 0;    
    open.push_back (depP);

    while (!ended && !open.empty ()) {
        for (i = 0; i < open.size (); ++i) {
            if (open[i].getP2 () < open[indTMP1].getP2 ())
                indTMP1 = i;
        }

        close.push_first (open[indTMP1]);
        open.erase (indTMP1);
        indTMP1 = 0;

        ended = true;
        for (i = 0; i < os; ++i) {
            if (obs[i].getCroisement (close[indTMP1].getX (), close[indTMP1].getY (), arr)) {
                ended = false;
                tmp = obs[i].getPoints ();

                // On vérifie si le point est sur la table
                if (tmp.p0.getX() < min_x_table || tmp.p0.getY() < min_y_table || tmp.p0.getX() > max_x_table || tmp.p0.getY() > max_y_table)
                    val[0] = false;
                // On vérifie si le point croise un obstacle
                for (j = 0; j < os && val[0]; ++j)
                    if (obs[j].getCroisement (tmp.p0, close[indTMP1]))
                        val[0] = false;
                // On vérifie si le point existe déjà dans la liste ouverte
                for (j = 0; j < open.size () && val[0]; ++j) {
                    if (open[j] == tmp.p0)
                        val[0] = false;
                }
                // On vérifie si le point existe déjà dans la liste fermée
                for (j = 0; j < close.size () && val[0]; ++j) {
                    if (close[j] == tmp.p0)
                        val[0] = false;
                }
                if (val[0]) {
                    open.push_back (pointParcours (tmp.p0, &close[indTMP1], arr));
                }

                // On repete l'operation pour le second point
                if (tmp.p1.getX() < min_x_table || tmp.p1.getY() < min_y_table || tmp.p1.getX() > max_x_table || tmp.p1.getY() > max_y_table)
                    val[1] = false;
                for (j = 0; j < os && val[1]; ++j)
                    if (obs[j].getCroisement (tmp.p1, close[indTMP1]))
                        val[1] = false;
                for (j = 0; j < open.size () && val[1]; ++j) {
                    if (open[j] == tmp.p1)
                        val[1] = false;
                }
                for (j = 0; j < close.size () && val[1]; ++j) {
                    if (close[j] == tmp.p1)
                        val[1] = false;
                }
                if (val[1]) {
                    open.push_back (pointParcours (tmp.p1, &close[indTMP1], arr));
                }

                // On répète l'opération pour le troisième point
                if (tmp.p2.getX() < min_x_table || tmp.p2.getY() < min_y_table || tmp.p2.getX() > max_x_table || tmp.p2.getY() > max_y_table)
                    val[2] = false;
                for (j = 0; j < os && val[2]; ++j)
                    if (obs[j].getCroisement (tmp.p2, close[indTMP1]))
                        val[2] = false;
                for (j = 0; j < open.size () && val[2]; ++j) {
                    if (open[j] == tmp.p2)
                        val[2] = false;
                }
                for (j = 0; j < close.size () && val[2]; ++j) {
                    if (close[j] == tmp.p2)
                        val[2] = false;
                }
                if (val[2]) {
                    open.push_back (pointParcours (tmp.p2, &close[indTMP1], arr));
                }

                // On répète l'opération pour le quatrieme point
                if (tmp.p3.getX() < min_x_table || tmp.p3.getY() < min_y_table || tmp.p3.getX() > max_x_table || tmp.p3.getY() > max_y_table)
                    val[3] = false;
                for (j = 0; j < os && val[3]; ++j)
                    if (obs[j].getCroisement (tmp.p3, close[indTMP1]))
                        val[3] = false;
                for (j = 0; j < open.size () && val[3]; ++j) {
                    if (open[j] == tmp.p3)
                        val[3] = false;
                }
                for (j = 0; j < close.size () && val[3]; ++j) {
                    if (close[j] == tmp.p3)
                        val[3] = false;
                }
                if (val[3]) {
                    open.push_back (pointParcours (tmp.p3, &close[indTMP1], arr));
                }

                val[0] = true;
                val[1] = true;
                val[2] = true;
                val[3] = true;
            }
        }
    }

    /* L'algorithme n'est pas bon. Je devrais prendre ici le plus court chemin vers l'arrivée pour ceux qui ne sont pas bloqués, et pas un aléatoire ... */
    if (ended) {
        pointParcours* pente;
        pente = &close[0];
        while (pente != NULL) {
            path.push_first (*pente);
            pente = pente->getPere ();
        }
        path.push_back (pointParcours(arr, NULL, arr));
        path.erase(0);
        endedParc = true;
        /*
        if (path.size() > 1)
            path.erase(0);*/
    }
}

void map::Execute(float XObjectif, float YObjectif) {
    logger.printf("Findway %f-%f -> %f-%f\n\r", Codo->getX(), Codo->getY(), XObjectif, YObjectif);
    FindWay (Codo->getX(), Codo->getY(), XObjectif, YObjectif);
    
    if (endedParc) {
        //logger.printf("\n\r");
        for (int i = 0; i < path.size (); i++) {
            logger.printf("Goto %d/%d [%f, %f]... \n\r", i, path.size()-1, path[i].getX(), path[i].getY());
            //the = (float) atan2((double) (p[i].gety() - odo.getY()), (double) (p[i].getx() - odo.getX())); 
            Codo->GotoXY((double)path[i].getX(), (double)path[i].getY());
            logger.printf("Goto Fini\n\r");
        }
        //logger.printf("Chemin fini !\n\r");
    }
    else {
        logger.printf("Chemin pas trouve ...\n\r");
    }
    endedParc = false;
}

void map::Execute(float XObjectif, float YObjectif) {
    // logger.printf("Findway %f-%f -> %f-%f\n\r", Codo->getX(), Codo->getY(), XObjectif, YObjectif);
    Objectif o;
    FindWay (Codo->getX(), Codo->getY(), o.getX(), o.getY());
    
    if (endedParc) {
        //logger.printf("\n\r");
        for (int i = 0; i < path.size (); i++) {
            // logger.printf("Goto %d/%d [%f, %f]... \n\r", i, path.size()-1, path[i].getX(), path[i].getY());
            //the = (float) atan2((double) (p[i].gety() - odo.getY()), (double) (p[i].getx() - odo.getX())); 
            Codo->GotoXY((double)path[i].getX(), (double)path[i].getY());
            // logger.printf("Goto Fini\n\r");
        }

        //logger.printf("Chemin fini !\n\r");
    }
    else {
        logger.printf("Chemin pas trouve ...\n\r");
    }
    endedParc = false;
}