#include "Stepper.h"
// ID AX12 : 3 et 1 
Stepper::Stepper(PinName _en, PinName _stepPin, PinName _dir, PinName _minEndStop, float step_per_mm):en(_en),
    stepPin(_stepPin),
    direction(_dir),
    minEndStop(_minEndStop)
{
    Step_Per_MM = step_per_mm;
}

bool Stepper::step(int _number, int _dir, float _speed, bool _async)
{
    if(done())
    {
        dir = _dir;
        number = _number;
        speed = _speed;
        async = _async;
        
        if (dir == HAUT)
            direction = 0;
        else if (dir == BAS)
            direction = 1;
        
        ticker.attach(this,&Stepper::tick,_speed);
        if(!_async)
            while(!done())
                wait(speed);
        
        return true;
    }
    
    return false;
    
    
    
    /*  Step...
    for(int i=0; i<number && !(minEndStop.read() == 0 && dir == BAS); i++)
    {
        stepPin = 1;
        wait_us(5);
        stepPin = 0;
        wait_us(5);
        wait(speed);
    }*/
}

bool Stepper::mm(int _number, int _dir, bool _async)
{
    return step(_number*Step_Per_MM, _dir, DELAY-0.001, _async);
}

bool Stepper::mm(float _distance, bool _async)
{
    return step(abs(_distance)*Step_Per_MM, (_distance>0?HAUT:BAS), DELAY-0.001, _async);
}

bool Stepper::done()
{
    return number == 0;
}

void Stepper::tick()
{
    stepPin = 1;
    wait_us(5);
    stepPin = 0;
    
    number--;
    
    if(number <= 0 || (minEndStop.read() == 0 && dir == BAS))
    {
        ticker.detach();
        number = 0;
    }
}


void Stepper::enable()
{
    en = 0;
}

void Stepper::disable()
{
    en = 1;
}