#ifndef CONTROLLEUR_PINCE_H
#define CONTROLLEUR_PINCE_H

//#include "defines.h"
#include "Stepper.h"
#include "AX12.h"
#include "mbed.h"

#define HAUT 1
#define BAS 0
#define DELAY 0.007

class ControlleurPince
{
    public:
        ControlleurPince(Stepper &p_RMot, Stepper &p_ZMot, Stepper &p_LMot, DigitalIn &p_EnR, DigitalIn &p_EnZ, DigitalIn &p_EnL, AX12 &_Lax12, AX12 &_Rax12);
    
        void init();
        void home(bool r=true, bool z=true, bool l=true);
        void setPos(float z, float delta, float center = -600);
        
        void close();
        void open();
    
    private:
    
        Stepper &RMot, &ZMot, &LMot;
        
        DigitalIn &EnR, &EnZ, &EnL;
        
        AX12 &Lax12, &Rax12;
        
        float pos_r,pos_z,pos_l;
};

#endif
