#ifndef MBED_STEPPER_H
#define MBED_STEPPER_H

#include "mbed.h"

class Stepper
{
public:
    Stepper(PinName _en, PinName _stepPin, PinName dir, PinName _minEndStop, float step_per_mm);
    void step(int number, int dir, float speed);
    void mm(int number, int dir);
    void mm(float distance);
    void enable();
    void disable();
    
    int getEndStop() {return minEndStop.read();}
    
    float Step_Per_MM;
private:
    DigitalOut en;
    DigitalOut stepPin;
    DigitalOut direction;
    DigitalIn minEndStop;
};


#endif