#ifndef PIDcontroller_H
#define PIDcontroller_H

class PIDcontroller
{
    private :
    float Kp;
    float Ki;
    float Kd;
    
    float err;
    float err_old;
    float err_sum;
    float consigne;
    float value;
    
    
    public :
    
    PIDcontroller()
    {
        Kp = (float)1;
        Ki = (float)1;
        Kd = (float)1;
        err = (float)0;
        err_old = (float)0;
        err_sum = (float)0;
        consigne = (float)0;    
        value =(float)0;
    }
    
    PIDcontroller(float Kp, float Ki, float Kd)
    {
        this->Kp = Kp;
        this->Ki = Ki;
        this->Kd = Kd;
        err = (float)0;
        err_old = (float)0;
        err_sum = (float)0;
        consigne = (float)0;        
        value = (float)0;
    }
    
    ~PIDcontroller()
    {
        
    }
        
    void reset()
    {
        err_old = (float)0;
        err_sum = (float)0;
    }
    void setConsigne(float consigne)
    {
        this->consigne = consigne;
    }
    
    float update(float currentValue, float dt = (float)0.1)
    {
        err = consigne - currentValue;
        err_sum = err_sum + err;
        float err_diff = err-err_old;
        err_old = err;   
        
        value = Kp*(err + Ki*err_sum + Kd*err_diff/dt);
        
        return value;
    }
    
    void setKp(float Kp)
    {
        this->Kp = Kp;
    }
    
    void setKi(float Ki)
    {
        this->Ki = Ki;
    }
    
    void setKd(float Kd)
    {
        this->Kd = Kd;
    }
    
    void set(float Kp, float Ki,float Kd)
    {
        setKp(Kp);
        setKi(Ki);
        setKd(Kd);
    }
    
};

#endif
