#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"

#define abs(x) (x<0?-x:x)

/** Motor
 *  Classe permettant de controler un moteur
 */
class Motor
{
    private:
        PwmOut pwm;
        DigitalOut dir;
        bool inverse;
        float speed;
        
    public:
        /** Création d'un moteur
         *
         * @param pwm Pin sur laquelle sort la PWM
         * @param dir Pin sur laquelle sort le bit de direction
         */
        Motor(PinName pin_pwm, PinName pin_dir): pwm(pin_pwm), dir(pin_dir)
        {
            inverse = false;
            speed = 0.0f;
            pwm.period_us(10);  
            pwm = 0.0f;  
            
        }
        
        virtual ~Motor(){}

        /** Fixe la vitesse du moteur
         *
         * @param s Vitesse du moteur entre -1 et 1
         */
        void setSpeed(float s)
        {
            float abss = abs(s);
            speed = s;
            pwm = abss;
            if(s > 0)
                dir = !inverse;
            else
                dir = inverse;
        }

        /** Retourne la vitesse théorique du moteur
         *
         * @return Vitesse du moteur entre -1 et 1
         */
        float getSpeed(){return speed;}

        /** Fixe l'invesrion de polarité
         *
         * Exemple :
         * @code
         * moteur.setSpeed(1); // le moteur tourne à pleine vitesse dans le sens trigo
         * moteur.setInverse(true); // le moteur tourne à pleine vitesse dans le sens anti-trigo
         * moteur.setSpeed(-1); // le moteur tourne à pleine vitesse dans le sens trigo
         * @endcode
         *
         * @param i Inversion de polarité
         */
        void setInverse(bool i)
        {
            inverse = i;
            
            setSpeed(speed);
        }

        /** Retourne l'état d'inversion de polarité
         *
         * @return True ou False
         */
        bool getInverse(){return inverse;}    
        
};


#endif