#ifndef ASSERVISSEMENT_H
#define ASSERVISSEMENT_H

#include "mbed.h"
#include "Odometry.h"
#include "Motor.h"

class Asservissement
{
public:
    Asservissement(Odometry &odometry, Motor &motorL, Motor &motorR);
    virtual void update(float dt) = 0;
    
    virtual void setGoal(float x, float y, float theta) = 0;
    virtual void setGoal(float x, float y) = 0;
    
    virtual void stop() = 0;
    
    virtual bool isArrived() = 0;
    
    virtual char getState() = 0;

protected:
    Odometry &m_odometry;
    Motor &m_motorL;
    Motor &m_motorR;
};


#endif
