#ifndef OBSTACLE_H_
#define OBSTACLE_H_

class Obstacle
{
    public:
        Obstacle(float robotRadius,int id);
        virtual ~Obstacle();
        
        virtual int height(float x, float y) = 0;
        
        void setBigShape(bool bs) {bigShape = bs;}
        bool isBigShape() {return bigShape;}
        
        void setSmoothBigShape(bool sbs) {smoothBigShape = sbs;}
        bool isSmoothBigShape() {return smoothBigShape;}
        
        void setRobotRadius(float robotRadius) {this->robotRadius = robotRadius;}
        float getRobotRadius() {return robotRadius;}
        
        int getId(){return id;}
        void setId(int id){this->id = id;}
        
        void activate(){active=true;}
        void desactivate(){active=false;}
        
        virtual void update(float dt){}
    protected:
        bool bigShape,smoothBigShape;
        bool active;
        float robotRadius;
        
        int id;
};

#endif
