#include "Obj_depot.h"

extern Motor motorL;
extern Motor motorR;
extern bool interruption;

Obj_depot::Obj_depot(float x, float y, float theta, AX12 *ax12_pince)
:Objectif(x,y,theta)
{
    this->ax12_pince = ax12_pince;
    desactivate();
}

void Obj_depot::run()
{
    ax12_pince->setMaxTorque(MAX_TORQUE);
    wait(0.1);
    ax12_pince->setGoal(PINCE_OUVERTE);
    wait(1);
    
    if(!interruption)
    {
        motorL.setSpeed(-0.3);
        motorR.setSpeed(-0.3);
        wait(0.5);
        motorL.setSpeed(0);
        motorR.setSpeed(0);
    }
    
    done = true;
}

int Obj_depot::isActive()
{
    if(!active)
        return false;
    
    if(ax12_pince->getGoal() == PINCE_OUVERTE)
        return false;
    
    return true;
}
