#ifndef POINT_H
#define POINT_H

#include <vector>

class Point;

class Point
{
    public:
    Point()
    {
        x=y=G=H=0;
    }
    
    Point(int x, int y, float G=0, float H=0) : x(x),y(y),G(G),H(H)
    {
        
    }
    
    virtual ~Point()
    {
        
    }
    
    Point operator=(const Point &acase)
    {
        x=acase.x;
        y=acase.y;
        G=acase.G;
        H=acase.H;
        p=acase.p;
        return *this;
    }
    
    void setx(int xx) { x=xx; }
    void sety(int yy) { y=yy; }
    void setG(float GG) { G=GG; }
    void setH(float HH) { H=HH; }
    void setParent(Point *pp) { p=pp; }
    void setParent() { p=0; }
    
    int getx() { return x; }
    int gety() { return y; }
    float getF() { return G+H; }
    float getG() { return G; }
    float getH() { return H; }
    Point* getParent() { return p; }
    
    
    bool in(std::vector<Point*> &list, unsigned int &pos)
    {
        for(unsigned int i=0;i<list.size();i++)
            if(list[i]->getx() == this->getx() && list[i]->gety() == this->gety())
            {
                pos = i;
                return true;
            }
        return false;
    }
    
    bool in(std::vector<Point*> &list)
    {
        for(unsigned int i=0;i<list.size();i++)
            if(list[i]->getx() == this->getx() && list[i]->gety() == this->gety())
                return true;
        return false;
    }
    
    private:
    int x;
    int y;
    float G;
    float H;
    Point *p;
};

#endif // POINT_H
