#ifndef MAP_H
#define MAP_H

#include "includes.h"

#include "Obstacle.h"
#include "Point.h"
#include <vector>

#define DIAG_COST 0.7071067/2
#define NDIAG_COST 0.5/2

#define LOG_LEVEL 2 //4 debug(very slow) - 3 errors/warnings/infos - 2 errors/warnings - 1 errors - 0 none
#define LOG_ASTAR 1
#define LOG_TENDEUR 1



class SimplePoint
{
    public:
        SimplePoint(float x, float y) : x(x),y(y) {}
        SimplePoint(const SimplePoint &p) : x(p.x),y(p.y) {}
        bool operator!=(SimplePoint& p) {return x!=p.x||y!=p.y;}
        virtual ~SimplePoint() {}
        float x,y;
};

class Map
{
    public:
        Map();
        ~Map();
        void build();
        
        int getHeight(float x, float y);
        
        // mpc : metre par case, par defaut chaque case fait 10cm
        // Position en mm !!
        char AStar(float x, float y, float goal_x, float goal_y, float mpc=100);
        
        
        std::vector<SimplePoint> path;
        std::vector<Obstacle*> obstacles;
    private:
};


#endif
