#include "Obs_rect.h"

Obs_rect::Obs_rect(float robotRadius, int id, float x1, float y1, float x2, float y2):Obstacle(robotRadius,id)
{
    this->x1 = (x1<x2) ? x1:x2;
    this->x2 = (x1<x2) ? x2:x1;
    this->y1 = (y1<y2) ? y1:y2;
    this->y2 = (y1<y2) ? y2:y1;
}

int Obs_rect::height(float x, float y)
{
    if(!active)
        return 0;
    if(bigShape)
    {
        if(x1 - robotRadius < x && x < x2 + robotRadius && y1 - robotRadius < y && y < y2 + robotRadius)
            return 32000; // Dans le grand rctangle
    }
    else
    {
        if(x1 < x && x < x2 && y1 < y && y < y2)
            return 32000; // Dans le petit rectangle
    }
    return 0;
}
