#include "mbed.h"
#include "Ascenseur.h"
#include "pinMap.hpp"


#define TAILLE_RX 11
#define TAILLE_TX 7
#define VIOLET 1
#define JAUNE 0


char bufferOrdre[TAILLE_RX-1];
char bufferAcquitement[TAILLE_TX] = "fini\n\r";
bool newOrdre = false;
bool mvtFini;
bool init_match = true;
bool couleur = VIOLET ;
 
Serial pc(SERIAL_TX, SERIAL_RX,115200);
Serial serial(PIN_TX, PIN_RX, 115200);
event_callback_t ordreRaspiCallback;

Ascenseur *ascenseur;

//init actionneurs
const char hydro[TAILLE_RX] = "TEShydro\n\r";
const char serbg[TAILLE_RX] = "TESserbg\n\r";
const char serbd[TAILLE_RX] = "TESserbd\n\r";
const char ascdr[TAILLE_RX] = "TESascdr\n\r";
const char ascga[TAILLE_RX] = "TESascga\n\r";
//init objet match
const char initJaune[TAILLE_RX] = "MATJinit\n\r";
const char initViolet[TAILLE_RX] = "MATVinit\n\r";

//ordres possibles
const char take4[TAILLE_RX] = "MATtake4\n\r";
const char accelerateurHaute[TAILLE_RX] = "MAThaute\n\r";
const char accelerateurBasse[TAILLE_RX] = "MATbasse\n\r";
const char lacherQuatre[TAILLE_RX] = "MAT4gacc\n\r";
const char lacherTroisGrand[TAILLE_RX] = "MAT3gacc\n\r";
const char lacherBleuGrandPente[TAILLE_RX] = "MATbgpen\n\r";
const char take3[TAILLE_RX] = "MATtake3\n\r";
const char lacherBleuPetitPente[TAILLE_RX] = "MATbppen\n\r";
const char take2[TAILLE_RX] = "MATtake2\n\r";
const char take2GrandBalance[TAILLE_RX] = "MAT2gacc\n\r";
const char finMatch[TAILLE_RX] = "MATfinir\n\r";

void recupererOrdre(int events);

int main() {
    
    //creer des objets de base violet et jaune  pour les tests 
    ascenseur = new Ascenseur(PIN_SERVO_ASCENSEUR_DROIT, PIN_SERVO_ASCENSEUR_GAUCHE, PIN_FIN_DE_COURSE_DROIT, PIN_FIN_DE_COURSE_GAUCHE, VIOLET);
    ascenseur->init();
    ordreRaspiCallback.attach(recupererOrdre);
    serial.read((uint8_t*)bufferOrdre, TAILLE_RX-1, ordreRaspiCallback, SERIAL_EVENT_RX_COMPLETE);
    pc.printf("debut\n\r");
    while(init_match == true)
    {
        if(newOrdre == true)
        {
            newOrdre = false;
            if(strcmp(bufferOrdre, hydro) == 0)
            {
                pc.printf("Activation de l'hydrolique init \n\r");
                ascenseur->test_pompe();
            }
            else if(strcmp(bufferOrdre, serbg) == 0)
            {
                pc.printf("Servo bras gauche\n\r");
                ascenseur->test_servo_G();
            }
            else if(strcmp(bufferOrdre, serbd) == 0)
            {
                pc.printf("Servo bras droit\n\r");
                ascenseur->test_servo_D();
            }
            else if(strcmp(bufferOrdre, ascga) == 0)
            {
                pc.printf("Ascenseur gauche\n\r");
                ascenseur->test_ascenseur_G();
            }
            else if(strcmp(bufferOrdre, ascdr) == 0)
            {
                pc.printf("Ascenseur droit\n\r");
                ascenseur->test_ascenseur_D();
            }
            else
            {
                //pc.printf("%s", bufferOrdre);
            }
        }
        if(mvtFini){
            mvtFini = false;
             serial.printf("%s", bufferAcquitement);
             }
    }
    while(1)
    {
        if(newOrdre == true)
        {
            newOrdre = false;
            
                if(strcmp(bufferOrdre, take4) == 0)
                {
                    pc.printf("Prendre 4 palets \n\r");
                    ascenseur->prendre_4_palets_dist();
                }
                else if(strcmp(bufferOrdre, accelerateurHaute) == 0)
                {
                    pc.printf("Positionner l'accelerateur en haut \n\r");
                    ascenseur->go_accelerateur();
                }
                //Match jaune stratégie 
                else if(strcmp(bufferOrdre, accelerateurBasse) == 0)
                {
                    pc.printf("Positionner l'accelerateur en bas \n\r");
                    ascenseur->go_distributeur();
                }
                else if(strcmp(bufferOrdre, lacherQuatre) == 0)
                {
                    pc.printf("Lacher les 4 palets du grand distributeur \n\r");
                    ascenseur->lacher_4_palets_acc();
                }
                else if(strcmp(bufferOrdre, lacherTroisGrand) == 0)
                {
                    pc.printf("Lacher trois palets du grand distributeur \n\r");
                    ascenseur->lacher_3_palets_acc();        //plus utilisé
                }
                else if(strcmp(bufferOrdre, lacherBleuGrandPente) == 0)
                {
                    pc.printf("Poser le bleu du grand distributeur dans la pente \n\r");
                    ascenseur->lacher_bleu_gr_dist();       //plus utilisé
                }
                //Match violet stratégie 
                else if(strcmp(bufferOrdre, take3) == 0)
                {
                    pc.printf("Prendre trois palets sur le petit distributeur \n\r");
                    ascenseur->prendre_3_petit_dist();
                }
                else if(strcmp(bufferOrdre, lacherBleuPetitPente) == 0)
                {
                    pc.printf("Poser le bleu du petit dristributeur dans la pente \n\r");
                    ascenseur->lacher_bleu_petit_dist();
                }
                else if(strcmp(bufferOrdre, take2) == 0)
                {
                    pc.printf("Prendre les deux derniers du grand distributeur\n\r");
                    ascenseur->prendre_2_palets_gr_dist();
                }
                else if(strcmp(bufferOrdre, take2GrandBalance) == 0)
                {
                    pc.printf("Prendre les deux palets les plus proche de la balance du grand distributeur\n\r");
                    ascenseur->prendre_2_palets_gr_dist_balance();
                }
                else if(strcmp(bufferOrdre, finMatch) == 0)
                {
                    pc.printf("Fin de match il faut stop ascenseur et la pompe \n\r");
                    ascenseur->fin_match(); 
                }
                
                else
                {
                    pc.printf("%s\n\r",bufferOrdre);
                }
            }
            
            if(mvtFini){
                mvtFini = false;
                 serial.printf("%s", bufferAcquitement);
                 }
        }
}


void recupererOrdre(int events)
{
    pc.printf("Buffer de reception : %s \n\r", bufferOrdre);
    newOrdre = true;
    if(strcmp(bufferOrdre, initJaune) == 0)
    {
        couleur = JAUNE ;
        init_match = false;
        delete ascenseur;
        ascenseur = ascenseur = new Ascenseur(PIN_SERVO_ASCENSEUR_DROIT, PIN_SERVO_ASCENSEUR_GAUCHE, PIN_FIN_DE_COURSE_DROIT, PIN_FIN_DE_COURSE_GAUCHE, JAUNE);
        //serial.printf("%s", bufferAcquitement);
    }
    else if(strcmp(bufferOrdre, initViolet) == 0)
    {
        couleur = VIOLET;
        init_match = false ;
        //serial.printf("%s", bufferAcquitement);
    }
    serial.read((uint8_t*)bufferOrdre, TAILLE_RX-1, ordreRaspiCallback, SERIAL_EVENT_RX_COMPLETE);
}