#include "mbed.h"
#include "TextLCD.h"
#include "DebounceIn.h"


/********************MacValveControlwithLCD**************************
What this code will do is implement the previous Mac Valve control code for automated testing with an LCD screen
and the ability to determine the pressure control variable.

Automated test code will exist, however the next test phase will have to be initiated with a button press. Furthermore,
I will still keep the pressure ++ after every test, because I still want the code to be as automated as possible.

I will also add in dual sensor capability, so I can get both flex sensor readings from one test. *Done
*/

#define VAL 0.1

LocalFileSystem local("local");

//analog out pin is 18 (the only analog out pin)
AnalogOut pcontroller(p18);

//analog in pins are 19 and 20 (will read sensor values from here)
AnalogIn voltIn(p19);
AnalogIn voltIn2(p20);

//now to define the solenoids
DigitalOut solenoid(p12);

//this is to define the replenish signal led
DigitalOut led(LED1); // was formerly moveOn
DigitalOut led2(LED2); // was formerly moveOn

//these are the buttons which will add or subtract values to the p value after each test
DigitalIn pPlus(p13);
DigitalIn pMinus(p14);

//this is to define the button to move to the next psi step
InterruptIn incCurl(p21);
InterruptIn decCurl(p22);
InterruptIn eStop(p23);

//initialize serial for debugging
Serial pc(USBTX, USBRX); // tx, rx

//initialize LCD for testing
TextLCD lcd(p15, p16, p27, p28, p25, p24, TextLCD::LCD16x2); // rs, e, d4-d7

Timer t;

Ticker controller;

/**********************************************************GLOBALS****************************************************************************/
float controlVal, p_term, i_term, d_term, correction, p;
float kp, ki, kd, time_step, desired, actual;
float E, last_E;
int running = 1;


/*****************************************************SUPPORT FUNCTIONS*********************************************************************/

//only works for pressure up to 33 psi (which is more than we'll need for one finger, so I will not address this problem)
float pToVal(float pressure){
    float c,e;
    //convert pressure to analog control value
    e = pressure;
    c = e / 33; // (/10 to get voltage required, /3.3 to get control value)
    return c;
}

void initController(void){
    kp = 200;
    ki = 20;
    kd = 1.25;
    
    i_term = 0;
    time_step = 0.0001;
    desired = 1;  
    E = 0; 
    last_E = 0;
} 

/*****************************************************INTERRUPT FUNCTIONS*********************************************************************/

void flashLED(void){
    led = !led;
}

void control(void){
    led = !led;    
    //make sure desired value is within bounds
    if(desired <= 0.3){
        desired = 0.3;
    }
    if(desired >= 1){
        desired = 1;
    }
    
    actual = voltIn.read();
    E = desired - actual;
    
    p_term = kp * E;
    i_term += ki * E * time_step;
    d_term = kd * (E - last_E) / time_step;
    
    correction = p_term + i_term + d_term;
    p = -1 * correction;
    last_E = E;
    
    //bound output
    if(p > 25)
        p = 25;
    if(p < 0)
        p = 0;            
  
    //get the value needed to control the pressure from interrupt
    controlVal = pToVal(p);
    //use value found to control proportional controller
    pcontroller.write(controlVal);
}

void increase(){
    p++;
    
    if(p < 8){
        p = 8;
    }    
    
    if(p > 22){
        p = 22;
    } 
    
    wait(0.2); 
}   

void decrease(){
    p--;
    
    if(p < 7){
        p = 0;
    }
    
    wait(0.2);  
}  

void stop(void){
    pcontroller.write(0);
    running = 0;
}

/************************************************************MAIN FUNCTION************************************************************************/

int main() {
   
   //setup pullups
   incCurl.mode(PullUp);
   decCurl.mode(PullUp);
   eStop.mode(PullUp);
   
   //attach interrupts 
   incCurl.rise(&increase);
   decCurl.rise(&decrease);
   eStop.rise(&stop);   
           
    //fill the finger
    solenoid = 1;

   float controlVal;

    while(1){
        if(running){
            //get the value needed to control the pressure
            controlVal = pToVal(p);
            
            //use value found to control proportional controller
            pcontroller.write(controlVal);
        }
    } 
}
