/*
    rouo2201
    carc2013
    mars 2016
*/

#include "mbed.h"
#include "math.h"

const float READ_FREQ = 1000; // Hz
const float COEFS[6] = {83.3290836569031,
                        -205.3425548207552,
                        192.4526548688262,
                        -086.3391258123220,
                        22.1364338760755,
                        -1.9947453761689};
const int MEAN_WEIGTH = 1000;
const int HEIGTH_OFFSET = 50;

DigitalOut led1(LED1);
AnalogIn input(p18);

int counter = 0;

float voltageToDistanceConv(float inputVal);

int main() 
{
    float rawInput = 0;
    float voltageInput;

    led1 = 1;
    
    while(1) 
    {
        rawInput += input.read();
        counter++;
             
        if(counter == MEAN_WEIGTH)
        {
            rawInput /= (float)MEAN_WEIGTH;
            voltageInput = 3.3 * rawInput;
            printf("raw input: %f, voltage: %f\r\n", rawInput, voltageInput);
            printf("heigth: %f\r\n", voltageToDistanceConv(rawInput) + HEIGTH_OFFSET);
            counter = 0;
            rawInput = 0;
        }
        
        wait(1/READ_FREQ);
    }
}

float voltageToDistanceConv(float inputVal)
{
    return COEFS[0]*pow(inputVal, 5) + COEFS[1]*pow(inputVal, 4) + COEFS[2]*pow(inputVal, 3) + COEFS[3]*pow(inputVal, 2) + COEFS[4]*inputVal + COEFS[5];
}
