#include "mbed.h"
#define FRAMEDELIMITER 0x7E
#include "rtos.h"

// 4269
DigitalOut resetswitch(p8);
Serial xbee(p13, p14);
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

void printhexa(char c)
{
    char msb = c >> 4;
    char lsb = c & 0xF;
    
    if (msb < 10)
        msb += 0x30;
    else
        msb += 0x37;
        
    if (lsb < 10)
        lsb += 0x30;
    else
        lsb += 0x37;
    
    pc.putc('0');
    pc.putc('x');
    pc.putc(msb);
    pc.putc(lsb);
    pc.putc(' ');
}

void ATCommandResponse(int len, char* ans)
{
    char total = 0x88;
    char id = xbee.getc();
    total += id;
    char command[2];
    command[0] = xbee.getc();
    total += command[0];
    command[1] = xbee.getc();
    total += command[1];
    char status = xbee.getc();
    total += status;
    int i = 0;
    len-= 4;
    char data[len];
    
    pc.printf("response to command %c%c", command[0], command[1]);
    pc.printf(" is ");
    
    while (i < len)
    {
        if (xbee.readable())
        {
            data[i] = xbee.getc();
            total += data[i];
            printhexa(data[i]);
            i++;
        }
    }
    
    char checksum = xbee.getc();
    total += checksum;
    // Verify checksum
    if (total != 0xFF)
    {
        pc.printf("Checksum is wrong");
    }
    pc.printf("\r\n");
    ans = data;
}
    
void ModemStatus(int len, char* ans)
{
    char status = xbee.getc();
    
    switch (status){
        case 0 : pc.printf("Hardware reset\r\n"); break;
        case 1 : pc.printf("Watchdog timer reset\r\n"); break;
        case 2 : pc.printf("Joined network (routers and end devices)\r\n"); break;
        case 3 : pc.printf("Disassociated\r\n"); break;
        case 6 : pc.printf("Coordinator started\r\n"); break;
        case 7 : pc.printf("Network security key was updated\r\n"); break;
        case 0x0D : pc.printf("Voltage supply limit exceeded\r\n"); break;
        case 0x11 : pc.printf("Modem configuration changed while join in progress\r\n"); break;
        default : pc.printf("stack error\r\n"); break;
    }
    
    char checksum = xbee.getc();
    
    checksum += 0x8A + status;
    
    if (checksum != 0xFF)
    {
        pc.printf("Checksum is wrong\r\n");
    }
    *ans = status;
}
    
char* InterpretMessage()
{
    char start = xbee.getc(); // = FRAMEDELIMITER
    //assert
    char len_msb = xbee.getc();
    char len_lsb = xbee.getc();
    
    int len = ((int) len_msb << 4) + (int) len_lsb;
    char frame_data[len];
    
    // Resolving frame type
    char type = xbee.getc();
    char *response;
    len--;
    
    switch (type){
        case 0x88: ATCommandResponse(len, response);
            break;
        case 0x8A: ModemStatus(len, response);
            break;
        default: pc.printf("Please implement response of type");
            printhexa(type);
            pc.printf("\r\n");
            for (int i = -1; i <len; i++) xbee.getc();
    }
    return response;
}

void SendAtCommand(char FirstChar, char SecondChar, char *OptionalParam = NULL, int ParamLen = 0)
{
    // Frame Type 0x08
    // Two char as parameters
    
    char cmdtosend[10];
    char sum = 0;
    int cmdlength = 8;
    int i = 0;
    
    cmdtosend[0] = FRAMEDELIMITER;
    cmdtosend[1] = 0x00;
    cmdtosend[2] = 0x04 + ParamLen;
    cmdtosend[3] = 0x08;
    cmdtosend[4] = 0x52;
    cmdtosend[5] = FirstChar;
    cmdtosend[6] = SecondChar;
    
    // Ajouter les parametres au message
    if(OptionalParam != NULL)
    {   
        i = 0;
        cmdlength += ParamLen;
        
        while (i < ParamLen)
        {
            pc.putc((OptionalParam)[i]);
            cmdtosend[7 + i] = (OptionalParam)[i];
            i++;
        }
        pc.printf("\r\n");
    }
    
    // Calculate checksum
    i = 3;
    while (i < (cmdlength - 1))
    {
        sum += cmdtosend[i];
        i++;
    }
    cmdtosend[cmdlength - 1] = 0xFF - sum;
    
    // Envoyer la commande sur UART
    i = 0;
    while (i < cmdlength)
    {
        xbee.putc(cmdtosend[i]);
        i++;
    }
    
    wait(0.1);
}

void ReadSerial()
{
    // 00 13 A2 00 
    // 40 3E 09 63
    SendAtCommand('S', 'H');
    SendAtCommand('S', 'L');
}

void xbee_reader()
{
    while(1)
    {
        if (xbee.readable())
        {
            InterpretMessage();
        }
        wait(0.001);   
    }
}

void tick()
{
    myled = !myled;   
}

int main() {
    Thread thread(xbee_reader);
    Ticker ticker;
    ticker.attach(&tick, 1);
    pc.printf("\r\n");
    resetswitch = 0;
    wait(0.4);
    resetswitch = 1;
    
    wait(3);
    ReadSerial();
    
    while(1) {
    }
}