#include "mbed.h"
#include "rtos.h"
#define FRAMEDELIMITER 0x7E

char GetTransmissionNumber();


class XBee {
    public:
        DigitalOut rst;   // Pin corresponding to the reset pin
        Serial comm;      // UART communication
        Mail<char, 250>* mail;
        Mail<char[256], 16>* webmail;
        Mail<char[254], 25>* frameresponsemail;
        
        char buffer[256];
        
        XBee(PinName reset, PinName transfer, PinName receive, Mail<char, 250>* m, Mail<char[256], 16>* w, Mail<char[254], 25>* r);
        char SendATCommand(char firstChar, char secondChar, char *optionalParam = NULL, int paramLen = 0);
        void ZigBeeTransmit(int adresse16, int adresse64msb, int adresse64lsb, char *data, int dataLength);
        void BroadcastHelloWorld();
        void InterpretMessage();
        void appendBuffer(char* c);
        void sendBuffer();
      
    private:
        void ATCommandResponse(int len);
        void ZigBeeTransmitStatus(int len);
        void ZigBeeReceivePacket(int len);
        void ModemStatus(int len);
        void printHexa(char c);
        void printInt(int i);
        void pcPrint(char* c);
        char getChar();
};
