// Emile Arseneault : arse1503
// Raphael Drouin   : dror2204

// Coordinator Node

#include "mbed.h"
#define FRAMEDELIMITER 0x7E
#include "rtos.h"
#include "xbee.h"

#include "EthernetInterface.h"
#include "Websocket.h"

// 4269
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

Mail<char, 250> mymail;
Mail<char[256], 16> webmail;
XBee xbee(p8, p13, p14, &mymail, &webmail);
Websocket* ws;

void ReadSerial()
{
    // 00 13 A2 00 
    // 40 3E 09 63
    xbee.SendATCommand('S', 'H');
    xbee.SendATCommand('S', 'L');
}

void InitialisePANID(char PANIDMSB, char PANIDLSB)
{
    char PanID[2] = {PANIDMSB, PANIDLSB};
    
    xbee.SendATCommand('I', 'D', &PanID[0], 2);
    wait(5);
    xbee.SendATCommand('M','Y');
    xbee.SendATCommand('O','P');
}

void BroadcastHelloWorld()
{
    char hello[5] = {'H', 'e', 'l', 'l', 'o'};
    char world[5] = {'w', 'o', 'r', 'l', 'd'};
    
    while (1)
    {
        xbee.ZigBeeTransmit(0xFFFE, 0x00000000, 0x0000FFFF, &hello[0], 5);
        xbee.ZigBeeTransmit(0xFFFE, 0x00000000, 0x0000FFFF, &world[0], 5);
        wait(2);
    }
}

void xbee_reader()
{
    while(1)
    {
        xbee.InterpretMessage();
        wait(0.001);   
    }
}

void tick()
{
    myled = !myled;   
}

void msg_reader()
{
    while (true) {
        osEvent evt = mymail.get();
        if (evt.status == osEventMail) 
        {
            char *c = (char*)evt.value.p;
            pc.putc(*c);
            mymail.free(c);
        }
    }
}

int main() {
    pc.printf("\r\nI am coordinator\r\n");
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
 
    ws = new Websocket("ws://192.168.137.1:4242");
    ws->connect();
    
    
    Ticker ticker;
    ticker.attach(&tick, 1);
    
    Thread thread(xbee_reader);
    Thread thread_reader(msg_reader);
    
    wait(3);
    ReadSerial();
    InitialisePANID(0x42, 0x69);
    
    while(1) {
        osEvent evt = webmail.get();
        if (evt.status == osEventMail) 
        {
            char *c = (char(*))evt.value.p;
            // Send email
            ws->send("sending");
            ws->send(c);
            wait(1);
            mymail.free(c);
        }
    }
}