#include "blink.h"

smartled::blink::blink(PinName name,smartled::bp * bp, std::size_t * click_cpt) : DigitalOut(name), m_bp(bp), m_click_cpt(click_cpt)
{
    
}

void smartled::blink::run(void)
{
    static blinkEtat state=off;
    
    switch(state)
    {
    case off:
        if(*m_click_cpt>0u)
        {
            *m_click_cpt= *m_click_cpt - 1u;
            m_timer.reset();
            m_timer.start();
            this->write(1);
            state=blinkOn;
        }
        break;
        
    case blinkOn:
        if(m_timer.read_ms()>250)
        {
            this->write(0);
            m_timer.reset();
            m_timer.start();
            state=blinkOff;
        }
        break;
        
    case blinkOff:
        if(m_timer.read_ms()>1000)
        {
            if(*m_click_cpt>0u)
            {
                *m_click_cpt= *m_click_cpt - 1u;
                m_timer.reset();
                m_timer.start();
                this->write(1);
                state=blinkOn;
            }
            else
            {
                m_timer.stop();
                state=off;
            }
        }
        break;        
    }
}

void smartled::blink::operator ()(void)
{
    this->run();
}