#include "bp.h"

smartled::bp::bp(PinName name, std::size_t * click_cpt) : DigitalIn(name), m_click_cpt(click_cpt)
{
    
}

void smartled::bp::run(void)
{
    static bpEtat state = init;
    
    switch(state)
    {
    case init :
        if(*this==1)
        {
            m_timer.reset();
            m_timer.start();
            state = under50ms;
        }
        break;
    case under50ms:
        if(*this == 0)
        {
            m_timer.stop();
            state=init;
        }
        else if (m_timer.read_ms()>50)
        {
            state = shortPush;
        }
        break;
    case shortPush:
        if(*this == 0)
        {
            if(m_isOnOff_On)
            {
                *m_click_cpt= *m_click_cpt + 1u;
            }
            m_timer.stop();
            state=init;
        }
        else if (m_timer.read_ms()>250)
        {
            state = longPush;
        }
        break;
    case longPush:
        if(*this == 0)
        {
            m_isOnOff_On=!m_isOnOff_On;
            *m_click_cpt = 0u;
            m_timer.stop();
            state=init;
        }
        break;
    }
}

bool smartled::bp::getIsOnOff_On(void)
{
    return m_isOnOff_On;
}

void smartled::bp::operator ()(void)
{
    this->run();
}