/************************************************************/
/*  Exemple à destination de APP2 de l'année 2018/2019      */
/*  Ne pas diffusé hors de la classe sans accord préalable  */
/*  Auteur : Thomas LINTANF                                 */
/************************************************************/

#include "mbed.h"

/* Pin assignement */
DigitalIn BP1(PC_13);
PwmOut pwm(PA_1);       // On definie l'objet pwm qui appartient à la classe PwmOut on met en paramètre la broche de sortie
                        // /!\ Attention : La broche ne doit pas être utiliser ailleur (DigitalOut par exemple) /!\


int main(void) 
{
    
    pwm.period_ms(10);  // On régle la période de la PWM, ici en millisecondes  rappel P=1/f ici : P=10 ms f=100hz
                        // (periode -> secondes, peridode_ms -> millisecondes et periode_us -> microsecondes)
                        // /!\ Attention : ne définir qu'une seule fois et hors du while(1) /!\
    
    pwm.write(0.5);     // On initialise le rapport cyclique à 50 %, la méthode write prend un float compri entre 0 et 1 qui 
                        // repésente le rapport cyclique. Il exite d'autre méthode pour définir le rapport cyclique en définissant
                        // la durée a l'état haut mais
    while(1) 
    {
        if(!BP1)
        {
            pwm=pwm.read()+0.1;  // ici pwm= **** equivaut à pwm.write( **** )
                                // pwm.read() renvoie la valeur actuelle du rapport cyclique sous forme d'un entier compri entre 0 et 1
                                
            if(pwm>=1)          // pwm ici et dans un calcule est équivalent à pwm.read()
            {                   // Le if ici est pour empécher d'avoir un rapport cyclique supérieur à 100% (physiquement et mathématique 
                pwm=1;          // c'est pas possible. Du coup si il y a dépassement on fixe la valeur à 1 -> 100 %
            }   
        }
    }
}
