#include "main.h"
  
DigitalOut cs(p14);         // Digital output used for the ship select control. 
DigitalOut myled(LED1);     //LED 
SPI spi(p11, p12, p13);     // SPI port (mosi, miso, sclk) 
I2C i2c(p9, p10);            // I2C port (sda, scl) 
//Serial pc(USBTX, USBRX);    // PC serial communication 

void WriteToRegister(int address, int startingRegister, int data2Write) 
{ 
    char data[2]; 
    data[0] = startingRegister; 
    data[1] = data2Write; 
  
    i2c.write(address, data, 2); 
} 
  
int ReadRegister(int address, int startingRegister) 
{ 
    char content[1]; 
    char reg[1]; 
    reg[0] = startingRegister; 
      
    i2c.write(address, reg, 1, true); 
    i2c.read(address, content, 1); 
      
    return content[0]; 
} 
  
char i2c_read_reg(char address) //fonction qui lit les valeurs des registres 
{    
    // Read from selected register adress 
    i2c.start();                                          
    i2c.write(MMA8452_WRITE_ADDRESS);    
    i2c.write(address);                  
    i2c.start();                         
    i2c.write(MMA8452_READ_ADDRESS);     
    char data = i2c.read(0);             
    i2c.stop();                          
   
    // return the data readed 
    return data;    
} 
  
bool initAccel() //fonction qui initialise l'accelerometre avec i2c 
{ 
    // Start I2C communication    
    char data = i2c_read_reg(WHO_AM_I); 
    if(data != 0x2A) 
    { 
        return false; 
    } 
      

  
// Put accelerometer in active mode at 6.25Hz 
    WriteToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x31); 
      
    // Put accelerometer in standby mode at 6.25Hz 
    WriteToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x30); 
       
    // Set accelerometer in 4g range 
    WriteToRegister(MMA8452_WRITE_ADDRESS, XYZ_DATA_CFG, 0x1); 
       
    // Put accelerometer in active mode at 6.25Hz 
    WriteToRegister(MMA8452_WRITE_ADDRESS, CTRL_REG1, 0x31); 
          
      
      
    return true;      
} 
  
  
  
unsigned short getAccelValue(char MSB_addr) //fonction qui lit les registres de données de l'accelerometre 
{ 
    return i2c_read_reg(MSB_addr);           // Read MSB data from MSB register 
} 
  
  
  
int main()  
{ 
        std::vector<int> x_array;
//      int i = 0;
    Thread thread1(collector_thread);
    
        
    //appelle des fonctions d'initialisations 
    initAccel();    //accelerometre 
    
    
      
    myled = 0; 
    
    while(1)  
    { 
        wait_ms(10); 
          
   
    } 
} 