#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "rtos.h"
#include "lib_crc.h"
#include <stdlib.h> /* atoi */
#include <string>
#include <bitset>

#define OCTET 8 
#define MAX_POOL_SIZE 696
#define PREAMBLE 0x55
#define START 0x3C
#define TYPE 0x00
#define STOP 0x3E

#define TIME 600000 // 100 ms

typedef struct {
  string trame;
  char size;
} message_t;


void Writer_thread(void const *args);
void Reader_thread(void const *args);
void Modulator_thread(void const *args);
void Demodulator_thread(void const *args);
void Sender_thread(void const *args);
void Receiver_thread(void const *args);

extern "C" void TIMER3_IRQHandler (void);
extern "C" void TIMER2_IRQHandler (void);


#endif // MAIN_H