#include "main.h"

extern Serial pc;
extern Queue<int, 16> ReaderQueue;
extern Mail<message_t, 16> mailBox;

void Modulator_init()
{

}

void buildTrame(string msg)
{
    string temp = "";
    string msgTemp = "";
    
    //Append preamble
    temp += bitset<8>(PREAMBLE).to_string<char,string::traits_type,string::allocator_type>(); 
    
    //Append Start bit
    temp += bitset<8>(START).to_string<char,string::traits_type,string::allocator_type>();
    
    //Append Type
    temp += bitset<8>(TYPE).to_string<char,string::traits_type,string::allocator_type>();
    
    //Append Length
    temp += bitset<8>(msg.size()*8).to_string<char,string::traits_type,string::allocator_type>();
    
    for (std::size_t i = 0; i < msg.size(); i++)
    {
         msgTemp += bitset<8>(msg.c_str()[i]).to_string<char,string::traits_type,string::allocator_type>(); 
    }
    
    temp += msgTemp;

    //Append CRC
    char *a = (char*)msgTemp.c_str();
    uint16_t crc = calculate_crc16(a, sizeof(a));

    temp += bitset<16>(crc).to_string<char,string::traits_type,string::allocator_type>();
    
    //Append Stop bit
    temp += bitset<8>(STOP).to_string<char,string::traits_type,string::allocator_type>();

    //Put the completed trame in the mail box
    message_t *mbTrame = mailBox.alloc();
    mbTrame->trame = temp;
    mbTrame->size = temp.size();
    mailBox.put(mbTrame);
}

void Modulator_thread(void const *args)
{
    string *queueItem;
    osEvent evt;
 
    Modulator_init();
    
    while(1)
    {
        evt = ReaderQueue.get();
        if (evt.status == osEventMessage) 
        {
            queueItem = (string*)evt.value.p;
            buildTrame(*queueItem);
        }
        
    }
}
// pc.printf("Test CRC16:     %04X\r\n",calculate_crc16(TestString, length));