#include "main.h"

extern Serial pc;
extern Mail<message_t, 16> mailBox;
DigitalOut myled(LED1);
unsigned int trameSize; 
unsigned int trameCounter;
char trameArray[696];
bool trameReady;

void Sender_init(void)
{
    myled = 0;
    trameCounter = 1;
    trameSize = 0;
    trameReady = false;
    
    // Enable the pins on the device to use TIMER MAT3.0
    LPC_PINCON->PINSEL0 |= 3<<20;
    
    NVIC_SetVector(TIMER3_IRQn, uint32_t(TIMER3_IRQHandler));
    
    LPC_SC->PCONP |=1<<23;            //timer3 power on
    LPC_TIM3->MR0 = TIME;           //100 msec ??
    LPC_TIM3->MCR |= 3;              //interrupt and reset control
                                    //3 = Interrupt & reset timer3 on match
                                    //1 = Interrupt only, no reset of timer3
    LPC_TIM3->TC = 0;                   // clear timer counter
    LPC_TIM3->PC = 0;                   // clear prescale counter
    LPC_TIM3->PR = 0;                   // clear prescale register
    LPC_TIM3->TCR = (1 << 1);               //reset Timer3
    LPC_TIM3->IR |= 1 << 0;         // Clear MR0 interrupt flag
    LPC_TIM3->EMR |= (3 << 4);        // enable MAT 3.0
    
    
    NVIC_EnableIRQ(TIMER3_IRQn);    //enable timer3 interrupt
   
}

extern "C" void TIMER3_IRQHandler (void)
{    
    char current = 0;
    char previous = 0;
    
    if((LPC_TIM3->IR & 0x01) == 0x01)   // if MR0 interrupt, proceed
     {
        LPC_TIM3->IR |= 1 << 0;         // Clear MR0 interrupt flag
         
        myled =!myled;
  
        if(trameReady == true) 
        {        
                      
                if(trameCounter <= trameSize)
                {   
                    current = trameArray[trameCounter];
                    previous = trameArray[trameCounter-1];
                    
                    if(current == previous)
                    {
                        LPC_TIM3->MR0 = (TIME/2);
                    } 
                    else
                    {
                        LPC_TIM3->MR0 = (TIME);
                    }
    
                    // next caracter
                    trameCounter++;
                    
                    // Activity light
                    myled =!myled;
                }
                else
                {
                    // Trame send, wait until a new trame is ready to send
                    trameReady = false;
                    LPC_TIM3->TCR = 0;
                    trameCounter = 1;  
                    myled= 0;   
                }
            }
        }
}

void Sender_thread(void const *args)
{
    Sender_init();
    
    while(1)
    {
        if(trameReady == false)
        {
            osEvent evt = mailBox.get();
            if (evt.status == osEventMail) 
            {
                message_t *mbTrame = (message_t*)evt.value.p;
                trameSize = mbTrame->size;
                
                strcpy(trameArray, mbTrame->trame.c_str());
                mailBox.free(mbTrame);  
                
                pc.printf("\n\r%s", trameArray);
                pc.printf("\n\r%d", trameSize);
                    
                trameReady = true;  
                LPC_TIM3->TCR = 1; 
            } 
        }
    }
}
