#include "main.h"

extern Serial pc;
extern Queue<string, 16> WriterQueue;
extern Mail<message_t, 16> mailBox;
message_t gTrame;
string dataTrame;


bool verifyCRC()
{
    bool result = false;
    
    dataTrame = "";
    string crcTrame = "";
    dataTrame = gTrame.trame.substr(32, gTrame.size);
    crcTrame = gTrame.trame.substr(32+gTrame.size, 16);
    
    char *a = (char*)dataTrame.c_str();
    uint16_t crc = calculate_crc16(a, sizeof(a));
    string crc_s = bitset<16>(crc).to_string<char,string::traits_type,string::allocator_type>();
    
    if(crc_s == crcTrame)
    {
        result = true;    
    }
    
    return result;
     //pc.printf("\n\r%s",dataTrame);
     //pc.printf("\n\r%s",crcTrame);
}

string rebuildMessage()
{
    string message;
    int tab[8] = {128, 64, 32, 16, 8, 4, 2, 1};
    int asciiValue = 0;

    for(int i=0; i<gTrame.size; i+=OCTET)
    {
        for(int y=0; y<OCTET; y++)
        {
            asciiValue += (dataTrame.c_str()[i+y]-48)* tab[y];
        }
        message += asciiValue;
        asciiValue = 0;
    }  
    
     return message;
}

void Demodulator_thread(void const *args)
{  
    while(1)
    {
       /* osEvent evt = mailBox.get();
        if (evt.status == osEventMail) 
        {
            message_t *mbTrame = (message_t*)evt.value.p;
            gTrame.trame = mbTrame->trame;
            gTrame.size = mbTrame->size;
            mailBox.free(mbTrame);
            
            pc.printf("get in the mail \n\r", gTrame.trame.c_str());
            
            pc.printf("\n\r%s", mbTrame->trame);
            if(verifyCRC())
            {
                 pc.printf("\n\r crc ok");
                 pc.printf("\n\r%s", rebuildMessage());
                //WriterQueue.put(new string(rebuildMessage())); 
                //pc.printf("put in the queue %s \n\r", gTrame.trame.c_str());
            }          
        }*/
    }
}