#include "main.h"

DigitalIn evenNum1(p15);
DigitalIn evenNum2(p16);

extern Queue<Event_t, 16> eventQueue;
extern Mutex queue_mutex;

void samplingNum(void const *n)
{
    static bool stateChanged[2] = {false, false};
    static bool value[2] = {1, 1};
    
    stateChanged[0] = (value[0] != evenNum1.read());
    stateChanged[1] = (value[1] != evenNum2.read());
    
    if((stateChanged[0] == true) || (stateChanged[1] == true))
    {
        wait_ms(50);
        stateChanged[0] = (value[0] != evenNum1.read());
        stateChanged[1] = (value[1] != evenNum2.read());
        
        if(stateChanged[0])
        {
            Event_t *event1 = new Event_t();
            event1->type = SWITCH_1;
            event1->time = time(NULL);
            queue_mutex.lock();
            eventQueue.put(event1);
            queue_mutex.unlock();
            value[0] = !value[0];
        }
        if(stateChanged[1])
        {
            Event_t *event2 = new Event_t();
            event2->type = SWITCH_2;
            event2->time = time(NULL);
            queue_mutex.lock();
            eventQueue.put(event2);
            queue_mutex.unlock();
            value[1] = !value[1];
        }
    }
}

void NumEvent_thread(void const *args)
{
    RtosTimer samplingTimer(samplingNum, osTimerPeriodic, (void *)0);
    samplingTimer.start(NUM_DELAY);
    while (true){}
}