#include "main.h"

Serial pc(USBTX, USBRX);
extern Queue<Event_t, 16> eventQueue;

const char* eventType[4] = {"Switch 1", "Switch 2", "Pot 1", "Pot 2 "};

void Collector_thread(void const *args)
{    
    Event_t *event;
    osEvent evt;
    
    while(true)
    {
        evt = eventQueue.get();
        if (evt.status == osEventMessage) 
        {
            event = (Event_t*)evt.value.p;
        }
        pc.printf("*** Event Type = %s    Time = %s \n\r", eventType[event->type], ctime(&event->time));
        
        delete event;   
    }
}