#include "main.h"

AnalogIn evenAnn1(p19);
AnalogIn evenAnn2(p20);

extern Queue<Event_t, 16> eventQueue;
extern Mutex queue_mutex;

short Average(short values[5])
{
    return ((values[0] + values[1] + values[2] + values[3] + values[4]) /5);
}

void samplingAnn(void const *n)
{
    static short tabPot1[5] = {0, 0, 0, 0, 0};
    static short tabPot2[5] = {0, 0, 0, 0, 0};
    static short currentValue[2] = {0, 0};
    short avg[2]= {0, 0};
    static short tabPtr = 0;
    static bool ready = false;
    
    currentValue[0] = evenAnn1.read() * 1000;
    avg[0] = Average(tabPot1);
    
    currentValue[1] = evenAnn2.read() * 1000;
    avg[1] = Average(tabPot2);
            
    if(ready)
    {
        if((currentValue[0] < (avg[0] - ANN_THRESOLD)) || (currentValue[0] > (avg[0] + ANN_THRESOLD)))
        {
            Event_t *event1 = new Event_t();
            event1->type = POT_1;
            event1->time = time(NULL);
            queue_mutex.lock();
            eventQueue.put(event1);
            queue_mutex.unlock();
        }
        
        if((currentValue[1] < (avg[1] - ANN_THRESOLD)) || (currentValue[1] > (avg[1] + ANN_THRESOLD)))
        {
            Event_t *event2 = new Event_t();
            event2->type = POT_2;
            event2->time = time(NULL);
            queue_mutex.lock();
            eventQueue.put(event2);
            queue_mutex.unlock();
        }
    }
    
    tabPot1[tabPtr] = currentValue[0];
    tabPot2[tabPtr] = currentValue[1];
    
    tabPtr++;
    if(tabPtr == 5)
    {
        tabPtr = 0;
        ready = true;
    }
}

void AnnEvent_thread(void const *args)
{
    RtosTimer samplingTimer(samplingAnn, osTimerPeriodic, (void *)0);
    samplingTimer.start(ANN_DELAY);
    while (true){}
}