#include "mbed.h"
#include "HTTPClient.h"
#include "C12832.h"
#include "EthernetInterface.h"
#include <string>
#include <stdlib.h>     /* srand, rand */
#include "rtos.h"
#include <sstream>
#include "USBAudio.h"
#include "Speaker.h"
 
/*
Account: mbedTokyoTech
Psswd: kalle123
Email: ricli877@student.liu.se
 
$consumerKey = 'XHO3e2fiS44d5i7xc6mvtvDdZ';
$consumerSecret = '9U4WOjRnpM5Pj0Qv4f6406jTRfN65YY5GeE5PRXHuhPfSiWhEN';
$accessToken = '4761221959-n4ojXEYR4DZSA4eeqt1WetVHHrZWTUNLJJ9ql3o';
$accessTokenSecret = 'SXM05FPIW9SUgTYYgpk4buPcypwXIsLDIY3TRns01WRJP';
*/

Serial pc(USBTX, USBRX);

DigitalIn button(p14);
 
EthernetInterface eth;
 
C12832 lcd(p5, p7, p6, p8, p11);
 
HTTPClient http;
 
BusIn joy(p15,p12,p13,p16);
 
Mutex locker;

Speaker speaker2(p26);

// sting buffers for tweeting
char str[512];
char buf[512];
//Enemy positions
int enX[17] = {75,37,19,93,59,21,80,65,27,45,47,49,54,94,62,104,28};
int enY[19] = {30,16,25,5,15,22,13,7,6,23,24,2,28,21,20,14,17,19,3};
//Food positions
int foodX[23] = {2,38,105,109,99,30,97,26,5,40,121,24,101,69,84,48,34,9,118,29,25,70,1};
int foodY[13] = {11,29,2,23,6,24,28,5,1,27,9,7,13};
 
//Stuff for the snakegame + joystick
int score = 0;
int s2 = 0;
int xPos = 50, yPos = 10;
int xDim = 128, yDim = 32;
int step = 4;
int xFood = foodX[0], yFood = foodY[0], xKiller=enX[0], yKiller=enY[0];
int foodIndex = 1;
int enemyIndex = 1;
 
bool gameOver = false;
bool gameOverScreen = false;
 
int k = 0;
 
int i = 0, j = 0;
 
bool hit2 = false;

//Function that checks if the food was eaten, returns true if it was.
bool hitFood(){
    if(abs(xFood - i) < 5 && abs(yFood - j) < 5) {
        score = score + 1;
        return true;
    }
    return false;
}

//Function that checks if the enemy was hit, return true if it was.
bool hitEnemy(){
    if(abs(xKiller - i) < 5 && abs(yKiller - j) < 5) {
        return true;
    }
    return false;
}
//Function that creates new food
void createNewFood(){
    xFood = foodX [foodIndex % sizeof(foodX)];
    yFood = foodY [foodIndex % sizeof(foodY)];
   
    xKiller = enX[enemyIndex % sizeof(enX)];
    yKiller = enY[enemyIndex % sizeof(enY)];
   
    while(abs(xKiller - xFood) < 5 || abs(yKiller - yFood) < 5){
        enemyIndex = enemyIndex + 1;
        xKiller = enX[enemyIndex % sizeof(enX)];
        yKiller = enY[enemyIndex % sizeof(enY)];
        
    }
   
    foodIndex = foodIndex + 1;
    enemyIndex = enemyIndex + 1;
    
    if(foodIndex > 9 || enemyIndex > 9) {
        foodIndex = 0;
        enemyIndex = 0;
    }
} 
 
//Set up game
void setUpGame() {
    score = 0;
    xPos = 50, yPos = 10;
    xDim = 128, yDim = 32;
    step = 4;
    xFood = foodX[0], yFood = foodY[0], xKiller=enX[0], yKiller=enY[0];
    foodIndex = 1;
    enemyIndex = 1;
}

//Function that shows gameover screen and plays end note
void gameOverFun(){
    speaker2.PlayNote(969.0, 0.5, 1.0);
    speaker2.PlayNote(800.0, 0.5, 1.0);
    lcd.cls();
    lcd.locate(xDim / 2 - 10, yDim / 2);
    lcd.printf("Game Over");
} 
   
//Function that actually draws the snake and handles the user input
void playSnake(void const *args)
{
    while(true) {
         if(gameOver){
                Thread::wait(10000);
            }
        
        if (!gameOver && !gameOverScreen) {

            setUpGame();
            
            while(!gameOverScreen) {
                
                //Handles joystick-input
                if(joy) {
                    if(joy == 0x4) {                    //Right Left
                        k=0;
                        i = i - step;
                        if(i < 0) i = xDim + i;
                    } else if(joy == 0x8) {             //Right Left
                        k=1;
                        i = (i + step) % xDim;
                    } else if(joy == 0x1) {             //Up Down
                        k=2;
                        j = j - step;
                        if(j < 0) j = yDim + j;
                    } else if(joy == 0x2) {             //Up Down
                        k=3;
                        j = (j + step) % yDim;
                    }
                }
                //Handles previous inputs if joystick used
                else {
                    if(k == 0) {
                        i = i - step;
                        if(i < 0) i = xDim + i;
                    } else if(k == 1) {
                        i = (i + step) % xDim;
                    } else if(k == 2) {
                        j = j - step;
                        if(j < 0) j = yDim + j;
                    } else if(k == 3) {
                        j = (j + step) % yDim;
                    }
                }
                lcd.cls();
                lcd.locate(i,j);
       
                int r = 3;
                //To move the score to not interfere with game
                if(i < xDim / 2) lcd.locate(xDim-10, 10);
                else lcd.locate(10,10);
                lcd.printf("%i", score);
               
                //Draw snake
                lcd.fillcircle(i, j, r, 1);
               
                //Draw enemy
                lcd.locate(xKiller,yKiller);
                lcd.printf("X");
                bool hitE = hitEnemy();
               
                //Draw food
                lcd.fillcircle(xFood, yFood, 2, 1);
                hit2 = hitFood();
               
                //To see if food was eaten
                if(hit2)
                    createNewFood();
                else if(hitE){
                    
                    gameOver = true;
                    gameOverScreen = true;
                    gameOverFun();
                }
                Thread::wait(50); // Used to control the speed of the game
            }
        }
    }
}
 
// Send msg to proxy script
void tweet(std::string msg) {
    std::string url ("http://www.rickardlindstedt.com/proxy.php?msg=");
    
    url = url + msg;
   
    // send HTTP request
    int ret = http.get(url.c_str(), str, 128);
    
    if (ret == HTTP_OK)
    {
      pc.printf("Success!\n");
    }
    else
    {
      pc.printf("Error #%d\n", ret);
    }
    
    //Used to restart game
    setUpGame();
}
 
// Set up ethernet network interface
void setUpNetwork() {
    eth.init();
    eth.connect();
}

//Thread for Tweet
void tweetHighscore(void const *args){
    setUpNetwork();
    while(true) {
        
        if (gameOver) {
            
            std::string msg;
            ostringstream convert;
            convert << score;
            msg = convert.str();
            tweet(msg);
            locker.lock();
            gameOver = false;
            
            bool restart = true;
            while(restart){
                if(joy) restart = false;
            }
            gameOverScreen = false;
            locker.unlock();
        }
        
        Thread::wait(1000);
    }
}

int main()
{
    createNewFood();
    
    Thread threadSnake(playSnake);
    Thread threadTweet(tweetHighscore);
    
   while(true) {
        Thread::wait(500);
    }
}