/*
Räknar ut tiden det tar från botten till toppen i ett hopp. 
Från det kan man räkna ut hur högt man hoppar, med hjälp av 
h = (g * pow(t,2)) / 2;


*/
#include "mbed.h"
#include "MMA7660.h"
#include "Speaker.h"


//To get the x,y,z movements
MMA7660 MMA(p28, p27);

//To write to the terminal
Serial pc(USBTX, USBRX); // tx, rx 
 
// app board joystick
// down: p12, left: p13, center: p14, up: p15, right: p16
BusIn joystick(p12, p13, p15, p16);

DigitalIn button(p14);
BusOut leds(LED1, LED2, LED3, LED4);

DigitalOut  red_(p23);
DigitalOut green_(p24);

Speaker speaker(p26);
float MAX = 1.0;
float g = 9.82;
float flightTime = 0, height = 0;
Timer t;

bool up = false;
bool top = false;

int main() {
 
 green_ = 1;
 pc.printf("Running mBed\n");
 if(!MMA.testConnection()) red_ = 0;
 
 while (true) {
    
    if(MMA.y() > MAX && !up){        
        up = true;
        //MAX = MMA.y();
        //Never go above 5000Hz, can damage the mbed.
        //pc.printf("%f", MMA.y());
        
    }
    if(MMA.y() == 0.0 && !top) {
        t.start();
        speaker.PlayNote(969.0, 0.5, 1.0);
        speaker.PlayNote(800.0, 0.5, 1.0);
        top = true;
    }
    if(MMA.y() == 0.0 && top) {
        t.stop();
        
        printf("The time taken was %f seconds\n", t.read());
        top = false;
        up = false; 
        flightTime = t.read();
        height = g * flightTime * flightTime * 0.5;
        
        printf("The jump height was %f meters\n", height);
        
        t.reset();
    }
     
    
    
    if (button){
        leds = 0xf; // turns all LEDs on
        green_ = 0;
    }    
    else{
        green_ = 1;
        red_ = 1;
        leds = joystick;
    }
    wait(0.01);
    
   
 }
}