#include "mbed.h"

Serial ble(PC_12,PD_2);  //BLE
Serial co2(PC_10,PC_11);  //CO2 sensor
AnalogIn flowIn(PA_1);  //Flow sensor
I2C si7051(PB_9, PB_8); //Si7051 temperature sensor

float flowVal1;
float flowVal2;
float Pressure;
float finalflow;

///Flow function///
float flow()
{
    flowVal1=3.3*flowIn; //Logic level 3.3
    flowVal2 = 1.5*flowVal1; //5v
    Pressure =(125*flowVal2)-62.5; //Used for calibration
    finalflow=(0.3425*sqrt(Pressure))-0.198; //Used for program, flow in litter per min
    return finalflow;
}

///CO2 setup///
int value;
float carbon()
{
    bool allow = false;
    char c;
    char co2_measure[5];
    int count=0;

    while(1) 
    {
        c = co2.getc();
        //based on the user manual PDF for the CO2 sensor, the value starts with "Z"
        //and we need to extract the right number of CO2 value
        if(c=='Z') {
            allow = true;
        }

        if(allow) {
            if(c>=48 && c<=57) {
                co2_measure[count]=c;
                count++;
            }
        
            if(count>=6) { 
                value = ((co2_measure[0]-'0')*100000+co2_measure[1]-'0')*10000+(co2_measure[2]-'0')*1000+(co2_measure[3]-'0')*100; 
                float CAR;
                CAR=(float)value/10000;
                count=0;
                allow=false;
                return CAR;
            }
        }
    }
}


int main()
{
    ble.baud(115200);

    ble.printf("$");//enter command mode only for rn
    wait(0.1);
    ble.printf("$$");//enter command mode
    wait(0.5);
    ble.printf("SN,Flow Calibration\r");//set new name
    wait(0.5);
    ble.printf("SS,C0\r");//set transparent uart
    wait(0.5);
    ble.printf("---\r");//enter data mode
    wait(0.5);
    
    ///TEMP SETUP///
    int tempAddr=0x80; //si7050 8bit address

    char wTemp[1];
    wTemp[0]=0xE3; //Hold master mode
    char rTemp[2]; //Temperature returns MSB and LSB
    //assume MBS in rTemp[0] and LSB in rTemp[1]

    char wInit[2];
    wInit[0]=0xE6; //User register 1
    wInit[1]=0x00; //Set 14 bit resolution, other read-ony registers shouldn't be affected

    si7051.write(tempAddr,wInit,2);
    ///END TEMP///
    
    float temp_code;
    float SiTemp;
    
    while(1) {
        si7051.write(tempAddr,wInit,2);
        si7051.write(tempAddr,wTemp,1);
        si7051.read(tempAddr,rTemp,2); //Returns 2 bytes
        temp_code=(rTemp[0]<<8)+rTemp[1];
        SiTemp=((175.72*temp_code)/65536)-46.85;
        
        ble.printf("Flow:%.2fl/s,CO2:%.2f%,Temperature:%.2fC\n", flow(),carbon(),SiTemp);
        wait(0.1);
    }

}
