#include "mbed.h"
#include "co2.h"

AnalogIn flowIn(A3);
AnalogIn temp(A2);
Timer t;
Thread co2Thread;
Thread flowThread;
Thread tempThread;

float flowVal;

void flow(){
    while(1){
          flowVal=3.3*flowIn; //Logic level 3.3
//        printf("Flow: %f", flowVal);
    }
}

 float t2Cel;
 
void getTemp(){
  while(1){
  float B = 3478; //Define thermistor constant
  float rRef=10e3; // Define reference resistance
  float r1=10e3; // Define thermistor resistance at 25 C
  float t1=25+273; // Define thermistor initial temperature s 25C in Kelvin
  float x = temp.read(); //Measure input voltage at pin A0 in bits
  float v = 3.3*x; //Convert bits into voltage
  float r2 = (3.3*rRef/v)-rRef; //Convert voltage into thermistor resistance
  float t2 = (B*t1)/(B-t1*log(r1/r2)); //Convert thermistor resistance into temperature in Kelvin (log means natural logarithm ln)
  t2Cel = t2-273; //Convert temperature from Kelvin to Celcius
//  printf("Temp: %f\n", t2Cel);
}
}



int main()
{      

    int myArray[9];
    long double var=0.0;
    float sigma=0.0;
    unsigned int sum=0;
    int difSum=0;
    int avg=0;
    unsigned long long sqSum=0;
    bool flag=false;
    
    flowThread.start(flow);
    tempThread.start(getTemp);
    carbon();
    t.start();
    
//    while(1){
//    printf("CO2: %d, Flow: %f, Temp: %f\n", carbon(), flowVal, t2Cel);  //COOL TERM
////    printf("$d %f %f;", carbon(), flowVal, t2Cel); //Serial plotter
//    }
    
    //SOLENOID PART//
    while(1){ 
        int array[9]={0,0,0,0,0,0,0,0,0};
        for(int i=0;i<=8;i++){
            array[i]=carbon();
        }
        //printf("%d %d %d %d %d %d %d %d %d\n", array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]);

    }

  for(int i=0;i<9;i++){  //Get first 9 carbon values
      myArray[i]=carbon();
      printf("%d ", myArray[i]);
  }
  
   printf("\n");
   
  while(flag!=true){
    for(int i=0;i<9;i++){ 
      sum+=myArray[i]; //Find sum
    }
    
    avg=sum/9;//find average
    
    printf("Avg: %d\n", avg);
    
    for(int i=0;i<9;i++){ 
      difSum+=(myArray[i]-avg)*(myArray[i]-avg); //Find sum of difference between value X and mean
    }
        
    var=difSum/9;
    sigma=sqrt(var);
    
    printf("Standard dev: %f\n", sigma);
    
    if(sigma>=0.5){ //Check against carbon plateau, if sd greater than plateau startPoint
        for(int x=0;x<8;x++){
          myArray[x]=myArray[x+1];  //Shift all carbon to left by 1
          printf("%d ", myArray[x]);
        }
        
        myArray[8]=carbon(); // get new carbon value in last array slot
        printf("%d\n", myArray[8]);

        sum=0;  //Reset variables
        sqSum=0;
        var=0;
        sigma=0;
        avg=0;
        difSum=0;
        
    }else{
      printf("TURN ON SOLENOID\n"); //Turn on second sensor
      flag=true; //Terminate loop because sd is at plateau startPoint
    }
  } 
  
}
