#include "mbed.h"
//I2C bus for both ZMOD and temperature sensor
 
Serial ttl(PC_12, PD_2); 
I2C ZMODtemp(PB_9, PB_8);
DigitalOut red(PC_4);
DigitalOut amber(PC_5);
DigitalOut green(PB_0);
int main()
{
        ttl.baud(115200); //baudrate for the serial connection, 9600 for hc05 115200 for rn

    ttl.printf("$");//enter command mode only for rn
    wait(0.5);
    ttl.printf("$$");//enter command mode
    wait(0.5);
    ttl.printf("SN,Si7051\r");//set new name
    wait(0.5);
    ttl.printf("SS,C0\r");//set transparent uart
    wait(0.5);
    ttl.printf("&,4782CC640611\r");//Assign mac
    wait(0.5);
    ttl.printf("---\r");//enter data mode
    wait(0.5);
    
    int ZMODTEMPaddr=0x80; //si7050 8bit address
    
    char wTemp[1];
    wTemp[0]=0xE3; //Hold master mode
    char rTemp[2]; //Temperature returns MSB and LSB
                    //assume MBS in rTemp[0] and LSB in rTemp[1]
    
    char wInit[2];
    wInit[0]=0xE6; //User register 1
    wInit[1]=0x00; //Set 14 bit resolution, other read-ony registers shouldn't be affected
    
    ZMODtemp.write(ZMODTEMPaddr,wInit,2);
    
    while(1){
        ZMODtemp.write(ZMODTEMPaddr,wInit,2); //maybe
        ZMODtemp.write(ZMODTEMPaddr,wTemp,1);
        ZMODtemp.read(ZMODTEMPaddr,rTemp,2); //Returns 2 bytes
        float temp_code=(rTemp[0]<<8)+rTemp[1];
        float temp=((175.72*temp_code)/65536)-46.85;
        ttl.printf("Temp: %f\n",temp_code);
        wait(1);
        red=1;
        amber=1;
        green=1;
        wait(2);
        red=0;
        amber=0;
        green=0;
        wait(2);        
    }
    
}