#include "mbed.h"
#include "iAQ_Core.h"
#include "Adafruit_SGP30.h"
#include"BME680.h"
BME680 myBME680     ( PC_1,PC_0, 400000 ); //BME680
iAQ_Core myiAQ_Core ( PB_11_ALT0,PB_10_ALT0, iAQ_Core::iAQ_Core_ADDRESS ); //iAQ-Core C
Adafruit_SGP30 sgp30(PB_14,PB_13); // SGP30    
I2C ZMODtemp(PB_9, PB_8); //ZMOD and Si7050
Serial ble(PC_12,PD_2);

iAQ_Core::iAQ_Core_status_t  aux;
iAQ_Core::iAQ_Core_data_t    myiAQ_Core_data;

///BME680 EXTRA FUNCTIONS///
Ticker      newReading;

uint32_t    myState = 0;

//@brief   FUNCTION PROTOTYPES
void    changeDATA     ( void );
void    user_delay_ms  ( uint32_t  period );
int8_t  user_i2c_read  ( uint8_t dev_id, uint8_t reg_addr, uint8_t *reg_data, uint16_t len );
int8_t  user_i2c_write ( uint8_t dev_id, uint8_t reg_addr, uint8_t *reg_data, uint16_t len );

void changeDATA ( void )
{
    myState = 1;
}

void user_delay_ms ( uint32_t period )
{
    wait( 0.01 );
}

int8_t user_i2c_read ( uint8_t dev_id, uint8_t reg_addr, uint8_t *reg_data, uint16_t len )
{
    int8_t rslt = 0; // Return 0 for Success, non-zero for failure

    uint32_t aux     =   0;
    aux      =   myBME680._i2c.write ( dev_id, (char*)&reg_addr, 1, true );
    aux      =   myBME680._i2c.read  ( dev_id, (char*)&reg_data[0], len );



    if ( aux == 0 ) {
        rslt     =   0;
    } else {
        rslt     =   0xFF;
    }


    return rslt;
}

int8_t user_i2c_write ( uint8_t dev_id, uint8_t reg_addr, uint8_t *reg_data, uint16_t len )
{
    int8_t rslt = 0; // Return 0 for Success, non-zero for failure

    uint32_t     aux     =   0;
    char         cmd[16] =  { 0 };
    uint32_t     i       =   0;

    // Prepare the data to be sent
    cmd[0]   =   reg_addr;
    for ( i = 1; i <= len; i++ ) {
        cmd[i]   =   reg_data[i - 1];
    }

    // Write data
    aux      =   myBME680._i2c.write ( dev_id, &cmd[0], len + 1, false );



    if ( aux == 0 ) {
        rslt     =   0;
    } else {
        rslt     =   0xFF;
    }


    return rslt;
}


int main()
{
    ble.baud(115200); //baudrate for the serial connection, 9600 for hc05 115200 for rn

    ble.printf("$");//enter command mode only for rn
    wait(0.1);
    ble.printf("$$");//enter command mode
    wait(0.5);
    ble.printf("SN,Testing 1 2 1 2 \r");//set new name
    wait(0.5);
    ble.printf("SS,C0\r");//set transparent uart
    wait(0.5);
    ble.printf("&,50278635E070\r");//Assign mac
    wait(0.5);
    ble.printf("---\r");//enter data mode
    wait(0.5);
    
    ///IAQ DOESN'T REQUIRE INITIALISATION///
    
    ///SGP30///
    sgp30.begin();//begin sgp30
    sgp30.IAQinit();//initialise sgp30
    
    
    
    ///BME680//
    struct bme680_dev gas_sensor;

    gas_sensor.dev_id   =   BME680_I2C_ADDR_PRIMARY;
    gas_sensor.intf     =   BME680_I2C_INTF;
    gas_sensor.read     =   user_i2c_read;
    gas_sensor.write    =   user_i2c_write;
    gas_sensor.delay_ms =   user_delay_ms;
    // amb_temp can be set to 25 prior to configuring the gas sensor
    // or by performing a few temperature readings without operating the gas sensor.
    gas_sensor.amb_temp =   25;


    int8_t rslt = BME680_OK;
    rslt = myBME680.bme680_init ( &gas_sensor );


    uint8_t set_required_settings;

    // Set the temperature, pressure and humidity settings
    gas_sensor.tph_sett.os_hum  = BME680_OS_2X;
    gas_sensor.tph_sett.os_pres = BME680_OS_4X;
    gas_sensor.tph_sett.os_temp = BME680_OS_8X;
    gas_sensor.tph_sett.filter  = BME680_FILTER_SIZE_3;

    // Set the remaining gas sensor settings and link the heating profile
    gas_sensor.gas_sett.run_gas = BME680_ENABLE_GAS_MEAS;
    // Create a ramp heat waveform in 3 steps
    gas_sensor.gas_sett.heatr_temp  = 320; // degree Celsius
    gas_sensor.gas_sett.heatr_dur   = 150; // milliseconds

    // Select the power mode
    // Must be set before writing the sensor configuration
    gas_sensor.power_mode = BME680_FORCED_MODE;

    // Set the required sensor settings needed
    set_required_settings = BME680_OST_SEL | BME680_OSP_SEL | BME680_OSH_SEL | BME680_FILTER_SEL | BME680_GAS_SENSOR_SEL;

    // Set the desired sensor configuration
    rslt = myBME680.bme680_set_sensor_settings ( set_required_settings, &gas_sensor );

    // Set the power mode
    rslt = myBME680.bme680_set_sensor_mode ( &gas_sensor );


    // Get the total measurement duration so as to sleep or wait till the measurement is complete
    uint16_t meas_period;
    myBME680.bme680_get_profile_dur ( &meas_period, &gas_sensor );

    struct bme680_field_data data;


    newReading.attach( &changeDATA, 1 );                                        // the address of the function to be attached ( changeDATA ) and the interval ( 1s )
    
    //END BME680///
    
    ///ZMOD AND TEMP///
    int ZMODTEMPaddr=0x80; //si7050 8bit address
    
    char wTemp[1];
    wTemp[0]=0xE3; //Hold master mode
    char rTemp[2]; //Temperature returns MSB and LSB
                    //assume MBS in rTemp[0] and LSB in rTemp[1]
    
    char wInit[2];
    wInit[0]=0xE6; //User register 1
    wInit[1]=0x00; //Set 14 bit resolution, other read-ony registers shouldn't be affected
    
    ZMODtemp.write(ZMODTEMPaddr,wInit,2);
    ///END ZMOD AND TEMP///
    
    while(1)
    {
        myiAQ_Core.iAQ_Core_GetNewReading (  &myiAQ_Core_data ); //Measurement from iAQ-Core C
        wait(0.1);
        sgp30.IAQmeasure();//Measurement from SGP30
        
        rslt = myBME680.bme680_get_sensor_data ( &data, &gas_sensor ); //Measurement for BME680
        
        ZMODtemp.write(ZMODTEMPaddr,wInit,2); //maybe?
        ZMODtemp.write(ZMODTEMPaddr,wTemp,1);
        ZMODtemp.read(ZMODTEMPaddr,rTemp,2); //Returns 2 bytes
        float temp_code=(rTemp[0]<<8)+rTemp[1];
        float SiTemp=((175.72*temp_code)/65536)-46.85;
        
        ble.printf( "iAQ CO2: %d, iAQ VOC: %d, iAQ Resistance: %d, SGP30 CO2: %d, SGP30 VOC: %d, BME680 Res: %d, BME680 Temp: %.2f, BME680 Hum: %.2f, BME680 Pres: %.2f, Si7051 temp: %.2f\r\n", myiAQ_Core_data.pred, myiAQ_Core_data.Tvoc, myiAQ_Core_data.resistance, sgp30.eCO2,sgp30.TVOC, data.gas_resistance ,( data.temperature/100.0f ) , ( data.humidity / 1000.0f ), ( data.pressure / 100.0f ) , SiTemp );  //Real results after 5 minutes of ON time
    
        rslt = myBME680.bme680_set_sensor_mode ( &gas_sensor ); //BME680 reset
      }
}