#include "mbed.h"
#include "iAQ_Core.h"

iAQ_Core myiAQ_Core ( PB_11,PB_10, iAQ_Core::iAQ_Core_ADDRESS );
Serial ble(PC_12,PD_2);

Ticker      newReading;

iAQ_Core::iAQ_Core_status_t  aux;
iAQ_Core::iAQ_Core_data_t    myiAQ_Core_data;
uint32_t                     myState = 0;


void changeDATA ( void )
{
    myState = 1;
}


int main()
{
    ble.baud(9600);
    
    uint32_t myWarmUpCounter  =   0;



    // iAQ-Core warm up is at least 5 minutes ( 300 * 1s ) or when the sensor is ready
    do
    {
      aux      =   myiAQ_Core.iAQ_Core_GetNewReading ( &myiAQ_Core_data );
      wait(1);
      myWarmUpCounter++;
    } while( ( myWarmUpCounter < 300 ) && ( myiAQ_Core_data.status == iAQ_Core::iAQ_Core_STATUS_RUNIN ) );


    newReading.attach( &changeDATA, 0.1);                                        // the address of the function to be attached ( changeDATA ) and the interval ( 1s )

    // Let the callbacks take care of everything
    while(1)
    {
      sleep();



      if ( myState == 1 ) {
        // New reading
        do {
            aux      =   myiAQ_Core.iAQ_Core_GetNewReading (  &myiAQ_Core_data );
            wait_ms(1);
        } while( myiAQ_Core_data.status != iAQ_Core::iAQ_Core_STATUS_OK );          // [TODO] Dangerous!!! The uC may get stuck here if something goes wrong!
                                                                                    // [WORKAROUND] Insert a counter.

        // Send data through the UART
        ble.printf( "Pred: %d | Tvoc: %d | Resistance: %d\r\n", myiAQ_Core_data.pred, myiAQ_Core_data.Tvoc, myiAQ_Core_data.resistance );
        wait(0.01);
        myState  =   0;                                                             // Reset the variable
      }

    }
}