#include "mbed.h"
 
Serial pc(PC_12, PD_2);
I2C i2c(PC_1,PC_0);
DigitalOut wake(PB_2);

uint16_t eco2, tvoc;

 
int main()
{
    int addr=0xB4;
    wake=0;
    // FIRST NEED TO INIT TO APP_START 
    //CHECK SYSTEM 1, PUT IN APP MODE, CECK SYSTEM 2, SET MODE
    
    char wID[1];
    wID[0]=0x20;
    char rID[1];
    
    i2c.write(addr,wID,1);
    i2c.read(addr,rID,1);
    pc.printf("ID: %x\n",rID[0]);
    wait(1);

    char wS[1];
    wS[0]=0x00;
    char rS[1];
    
    i2c.write(addr,wS,1);
    i2c.read(addr,rS,1);
    pc.printf("Status before init: %x\n",rS[0]);
    wait(1);

    char wInit[2];
    wInit[0]=0xF4;
//    wInit[1]=0x00;
//    char rInit[1];
    
    i2c.write(addr,wInit,1);
    wait(1);
    
    i2c.write(addr,wS,1);
    i2c.read(addr,rS,1);
    pc.printf("Status after init: %x\n",rS[0]);
    wait(2);
    
    char wMode[2];
    wMode[0]=0x01;
    wMode[1]=0x40;
    char rMode[1];
    
    i2c.write(addr,wMode,2);
    i2c.read(addr,rMode,1);
    pc.printf("Mode: %x\n",rMode[0]);
    wait(1);
    
    char wE[1];
    wE[0]=0xE0;
    char rE[1];
    
    char wData[1];
    wData[0]=0x02;
    char rData[6];
    
    
    while(1){
        i2c.write(addr,wData,1); //co2 and tvoc
        i2c.read(addr,rData,6);
                
        int CO2=(rData[0]<<8)+rData[1];
        int TVOC=(rData[2]<<8)+rData[3];


        pc.printf("CO2: %i ppm, TVOC: %i ppb,Status: %x, Error: %x\n",CO2,TVOC,rData[4],rData[5]);
        wait(0.1);
    }
    
}