#include "mbed.h"

// First the inputs and pins are defined

AnalogIn flowIn(PA_1);//PA0 on schematic but PA1 on PCB
Serial co2(PC_10,PC_11);
AnalogIn sensor1(PC_0);
AnalogIn sensor2(PC_1);
AnalogIn sensor3(PC_2);
AnalogIn sensor4(PC_3);
AnalogIn sensor5(PA_4); //Also 2612
AnalogIn sensor6(PA_5); //Also 2610
AnalogIn sensor7(PA_6); //Also 2620
AnalogIn sensor8(PA_7); //Also 2602
AnalogIn temp(PA_0);//PA1 on schematic but PA0 on PCB

///////////////////// FLOW LOOP /////////////////////////
float finalflow;
float flowVal1;
float flowVal2;
float P1;
int flag=0;
int o=0;
float bpArray[10];
float fp;
float sp;
float FPressure;

float flow()
{
    while(1) 
    {
        wait(0.01);
        flowVal1=3.3*flowIn; //Logic level 3.3
        flowVal2 = 1.5*flowVal1; //5v
        P1 =(125*flowVal2)-62.5; //Pressure
        //making the value of pressure positive inside the SQRT function:
        if(flag==0)
        {
            finalflow=0;
            bpArray[o]=P1;  
            sp+=bpArray[o];
            o=o+1;
                    if (o==9)
                    {
                        fp=sp/10;
                        flag=1;
                    }            
        }
        if (flag==1)
        {
          FPressure=P1-fp;
          finalflow=(0.1724*sqrt(FPressure))+0.1637; //flow in litter per second, recalibrated at Imperial
            if(isnan(finalflow)==true){
                return 0;
                }
          else{
              return finalflow;
              }
        }
    }
}

///////////////////// CO2 LOOP /////////////////////////
int value;
float carbon()
{
    bool allow = false;
    char c;
    char co2_measure[5];
    int count=0;

    while(1) 
    {
        c = co2.getc();
        //based on the user manual PDF for the CO2 sensor, the value starts with "Z"
        //and we need to extract the right number of CO2 value
        if(c=='Z') {
            allow = true;
        }

        if(allow) {
            if(c>=48 && c<=57) {
                co2_measure[count]=c;
                count++;
            }
        
            if(count>=6) { 
                value = ((co2_measure[0]-'0')*100000+co2_measure[1]-'0')*10000+(co2_measure[2]-'0')*1000+(co2_measure[3]-'0')*100; 
                float CAR;
                CAR=(float)value/10000;
                count=0;
                allow=false;
                return CAR;
            }
        }
    }
}

///////////////////// TEMPERATURE LOOP /////////////////////////

float t2Cel;

float getTemp()
{
    while(1) {
        float B = 3380.00; //Define thermistor constant
        float rRef=10000.00; // Define reference resistance
        float r1=10000.00; // Define thermistor resistance at 25 C
        float t1=25.00+273.00; // Define thermistor initial temperature s 25C in Kelvin
        float x = temp.read(); //Measure input voltage at pin A0 in bits
        float v = 3.3*x; //Convert bits into voltage
        float r2 = (5*rRef/v)-rRef; //Convert voltage into thermistor resistance
        float t2 = (B*t1)/(B-t1*log(r1/r2)); //Convert thermistor resistance into temperature in Kelvin (log means natural logarithm ln)
        t2Cel = t2-273.00; //Convert temperature from Kelvin to Celcius
        return t2Cel;
//  printf("Temp: %f\n", t2Cel);
    }
}

///////////////////// 8-CHANNEL SENSOR LOOP /////////////////////////

int c2612S0()
{
    float sen5;
    float v5;
    float res5;
    float r5;
    
    while(1){
        v5=3.3*sensor5;
        res5=5/v5;
        r5=res5-1;
        sen5=1000*r5;
        return (int)sen5;
    }
}

int c2612S1()
{
    float sen5;
    float v5;
    float res5;
    float r5;
    
    while(1){
        v5=(3.3*sensor5);
        res5=5/v5;
        r5=res5-1;
        sen5=1000*r5;
        return (int)sen5;
    }
}

int c2610S0()
{
    float sen6;
    float v6;
    float res6;
    float r6;
    
    while(1){
        v6=3.3*sensor6;
        res6=5/v6;
        r6=res6-1;
        sen6=1000*r6;
        return (int)sen6;
    }
}

int c2610S1()
{
    float sen6;
    float v6;
    float res6;
    float r6;
    
    while(1){
        v6=(3.3*sensor6);
        res6=5/v6;
        r6=res6-1;
        sen6=1000*r6;
        return (int)sen6;
    }
}

int c2620S0()
{
    float sen7;
    float v7;
    float res7;
    float r7;
    
    while(1){
        v7=3.3*sensor7;
        res7=5/v7;
        r7=res7-1;
        sen7=1000*r7;
        return (int)sen7;
    }
}

int c2620S1()
{
    float sen7;
    float v7;
    float res7;
    float r7;
    
    while(1){
        v7=(3.3*sensor7);
        res7=5/v7;
        r7=res7-1;
        sen7=1000*r7;
        return (int)sen7;
    }
}

int c2602S0()
{
    float sen8;
    float v8;
    float res8;
    float r8;
    
    while(1){
        v8=3.3*sensor8;
        res8=5/v8;
        r8=res8-1;
        sen8=1000*r8;
        return (int)sen8;
    }
}

int c2602S1()
{
    float sen8;
    float v8;
    float res8;
    float r8;
    
    while(1){
        v8=(3.3*sensor8);
        res8=5/v8;
        r8=res8-1;
        sen8=1000*r8;
        return (int)sen8;
    }
}

int s1()
{
    int sen1;
    while(1){
            sen1=((5E6)/(sensor1*3.3))-(5E6);
            return sen1;
            }
}
int s2()
{
    int sen2;
    while(1){
            sen2=((5E6)/(sensor2*3.3))-(5E6);
            return sen2;
            }
}
int s3()
{
    int sen3;
    while(1){
            sen3=((5E6)/(sensor3*3.3))-(5E6);
            return sen3;
            }
}
int s4()
{
    int sen4;
    while(1){
            sen4=((5E6)/(sensor4*3.3))-(5E6);
            return sen4;
            }
}
int s5()
{
        int sen5;
        while(1){
                sen5=((5E6)/(sensor5*3.3))-(5E6);
                return sen5;
                }
}
int s6()
{
        int sen6;
        while(1){
                sen6=((5E6)/(sensor6*3.3))-(5E6);
                return sen6;
                }
}
int s7()
{
        int sen7;
        while(1){
                sen7=((5E6)/(sensor7*3.3))-(5E6);
                return sen7;
                }
}
int s8()
{
        int sen8;
        while(1){
                sen8=((5E6)/(sensor8*3.3))-(5E6);
                return sen8;
                }
}