#include "mbed.h"
#include "flow.h"
#include "SDFileSystem.h"

//  ***********************
//  Defining pins
//  ***********************

//Serial ble(A4,A5);    //bluetooth tx, rx     
AnalogIn neg(D3);       //negative button
AnalogIn pos(D6);       //positive button
SDFileSystem sd(D11, D12, D13, D9, "sd"); // MOSI(SDI), MISO(SDO), Clock, CS

//  ***********************
//  Main Initials defining:
//  ***********************

int main() {
    //ble.baud(9600);       //enable if you are using bluetooth
    
    //parameters used for finding base flow, sampling and calculating maximum and average of flow and CO2 samples
    float mc,ac;
    float maximum;
    float maximumco2; 
    float co2Array[80];
    float flowArray[40];
    float fv=0;
    float sf=0;
    float bfArray[4];
    float sum=0;
    double finalsum;
    float avg=0;
    float flowsum[39];
    int j=0;
    int i=0;
    int f=0;
    int cn=0;
    int score;
    
    ////////////calling flow and CO2 functions from flow.h///////
    carbon();
    flow();
    /////////////////////////////////////////////////////////////
    
    //////////////Flags for starting each section/////////////
    int measurement_started = 0;
    int cflag=0;
    int msg=0;
    int bf=0;
    int msg1 = 0;
    int msg2 = 0;
    int positive = 0;
    int negative =0;
    float pos2;
    float neg2;
    int symyes =0;
    int symno =0;
    float symy;
    float symn;
    int maxflag=0;
    int ready=0;
    
    /////////////Used for saving answers to the initial questions on SD card
    int good=0;
    int bad=0;
    int yes=0;
    int no=0;
    
//  ***********************
//  Program loop starts:
//  ***********************
    
    printf("First, please indicate if you feel good or not.\n");
        while(1){
            
        // converting the positive and negative inputs to voltage
            
        pos2=pos*3.3;
        neg2=neg*3.3;
        
        /////////////detecting base flow before breath////////////
        if (bf==0)
            {
              for(i=0; i<4; i++) 
                  {
                    bfArray[i]=flow();  
                    sf+=bfArray[j];                  
                  }   
               fv=sf/4;
               fv=fv+0.2;
               bf=1;
             }
             
        //// If the CO2 percentage is less than 1% starts the program by asking questions first/////
        
        if((carbon()<10000) and (ready ==1))
            {
                printf("Now you can breathe into device. \n");
                 printf("First, please indicate if you feel good or not.\n");
                ready=0;
            }
            
            //User answers the first question by pushing one of the buttons, so the code
            //proceeds to the next question and saves the answer for the first question.
            
              if(msg1==0)
              {
                  if(neg2>2)
                  {
                      negative=1;
                      printf("Have you experienced any symptoms today?\n");
                      if(neg2<1)
                      {
                          msg2=1;
                          msg1=1;
                      }
                      msg2=1;
                      msg1=1;
                  }
                 if(pos2>2)
                 {
                  positive = 1;
                  printf("Have you experienced any symptoms today?\n");
                  if(pos2<1)
                      {
                          msg2=1;
                          msg1=1;
                      }
                  msg2=1;
                  msg1=1;
                 }

               }
               
        //User answers the second question and the answer will be saved to be used later.
        if((msg1==1) and (msg2==1))
        {
         symy=pos*3.3;
         symn=neg*3.3;
              if(symy>2)
                      {
                          symyes=1;
                          printf("*BEEP*\n");
                          printf("Now please breath into the device.\n");
                          msg2=0;
                      }
                      if(symn>2)
                      {
                          symno=1;
                          printf("*BEEP*\n");
                          printf("Now please breath into the device.\n");
                          msg2=0;
                      }
        }
        
        //Now the device is ready to be used.
        //Here it detects the breath and starts sampling flow and CO2
        if ((flow()>fv) and (measurement_started ==0)) 
        {
          printf("Please keep exhaling for: \n");
          printf("4 seconds...\n");
             measurement_started = 1;

        }

        // 40 samples of flow and 80 samples of CO2 will be generated
        // The first 4 loops has a wait function that lasts 0.1 second, 
        // and it takes 10 samples, so overall, each loop takes 1 second long to be finished. 
        
        if (measurement_started == 1) 
        {
            for(j=0; j<10; j++) {
                flowArray[j]=flow();
                co2Array[j]=carbon();
                wait(0.1);
            }
            printf("3 seconds... \n");
            for(j=10; j<20; j++) {
                flowArray[j]=flow();
                co2Array[j]=carbon();
                wait(0.1);
            }
            printf("2 seconds...\n");
            for(j=20; j<30; j++) {
                flowArray[j]=flow();
                co2Array[j]=carbon();
                wait(0.1);
            }
             printf("1 second... \n");
            for(j=30; j<40; j++) {
                flowArray[j]=flow();
                co2Array[j]=carbon();
                wait(0.1);
            }
            
            //after sampling flow for 4 seconds, it continues sampling CO2 for 40 more samples
            //to cover the whole plateau. Actually these 80 samples of CO2 profile are the important
            //part of the graph, it can be considered as the plateau and it is the only data 
            //for CO2 that is saved and used for calculations.
            
            printf("*BEEP* *BEEP* Done!\n");
            for(j=40; j<80; j++) {
                co2Array[j]=carbon();
                wait(0.1);
            }
            printf("Calculating results... \n");
            
            //I replced the CO2 values less than 1% with new values in the end of the plateau
            //and put them at the end of the set of data in the array
            //so we have the right shape of the plateau
            
            for(j=0; j<80; j++) {
                if(co2Array[j]<10000) {
                    cn=cn+1;
                    co2Array[j]=carbon();
                    wait(0.1);
                } else {
                    break;
                }
            }


            measurement_started = 0;
            maxflag=1;
        }

        ////////calculating maximum flow//////////////

        if((maxflag == 1) and (measurement_started == 0)) 
        {

            maximum = flowArray[0];

            for (j = 1; j < 40; j++) 
            {

                if (flowArray[j] > maximum) 
                {

                    maximum  = flowArray[j];

                }
            }
            maxflag=0;
            measurement_started =1;
        }
        if((flow()<fv) and (measurement_started == 1)) {
            
            measurement_started = 0;

            //////////measuring lung capacity//////////
            
             for(j=0; j<39; j++) 
             {
                flowsum[j]=((flowArray[j]+flowArray[j+1])*0.1)/2;
                finalsum+=flowsum[j];
             }
            
//  ***********************
//  Results section:
//  ***********************

        printf("********* \n"); 
        printf("Your breath results: \n");
        printf("********* \n");
        
        if (positive==1)
            {
                printf("Patient felt healthy,");
                good=1;
                positive=0;
            }
            if (negative==1)
            {
                printf("Patient felt unhealthy,");
                bad=1;
                negative=0;
            }
            if (symyes == 1)
            {
                printf(" and had experienced symptoms. ");
                yes=1;
                symyes =0;
            }
            if (symno ==1)
            {
                printf(" and hadn't experienced any symptoms. ");
                no=1;
                symno=0;
            }
            
            ///////////Scoring system based on lung capacity////////
            
            if (finalsum<0.9) {
                printf("Breath Score: 1 \n");
                score=1;
                
            }
            if((finalsum>1) and (finalsum<1.9)) {
                printf("Breath Score: 2 \n");
                score=2;
              
            }
            if((finalsum>2) and (finalsum<2.9)) {
                printf("Breath Score: 3 \n");
                score=3;
            
            }
            if((finalsum>3) and (finalsum<3.9)) {
                printf("Breath Score: 4 \n");
                score=4;
              
            }
            if((finalsum>4) and (finalsum<10)) {
                printf("Breath Score: 5 \n");
                score=4;
            
            }
            
            printf("Maximum Flow: %3.2f Litres/Second \n",maximum);
            printf("Lung Capacity: %3.2f Litres \n",finalsum);
            
            
            
            fv=0;
            cflag=1;
        }
        
        /////////Measuring Maximum CO2////////////
        
        if(cflag==1) 
        {
            for(j=0; j<80; j++) 
            {
                sum+=co2Array[j];
            }
            maximumco2 = co2Array[0];

            for (j = 1; j < 80; j++) 
            {

                if (co2Array[j] > maximumco2) 
                {
                    maximumco2  = co2Array[j];
             
                }
            }
            mc=maximumco2/10000;
            printf("Maximum CO2: %3.2f percent \n",mc);
            avg=sum/80;
            ac=avg/10000;
            printf("********* \n");
            printf("Nice Job! Please wait for the next try. \n");
            
            f=1;
        }

//  ***********************
//  Saving section:
//  ***********************

        if(f==1){
         mkdir("/sd/mydir", 0777);
        
        FILE *fp = fopen("/sd/mydir/sdtest.xls", "w");
        if(fp == NULL) {
            error("Could not open file for write\n");
        }   
        fprintf(fp, "Results\t\n Health\t");
        if(good==1)
            {
                fprintf(fp, "Good\n");
            }
        if(bad==1)
            {
                fprintf(fp, "Bad\n");
            }
            
        fprintf(fp, "Symptoms\t");
        if(yes==1)
            {
                fprintf(fp, "Yes\n");
            }
        if(no==1)
            {
                fprintf(fp, "No\n");
            }
        fprintf(fp, "Score\t %d\n",score);
        fprintf(fp, "Max Flow\t %f\n",maximum);
        fprintf(fp, "Lung Capacity\t %f\n",finalsum);
        fprintf(fp, "Max CO2\t %f\n",mc);
        for(j=0; j<40; j++)
            {
                fprintf(fp, "Flow profile\t %f\n",flowArray[j]);
            }
        for(j=cn; j<80; j++)
            {
                fprintf(fp, "Co2 profile\t %f\n",co2Array[j]);
            }
        for(j=0; j<cn; j++)
            {
                fprintf(fp, "Co2 profile\t %f\n",co2Array[j]);
            }    
            
        fclose(fp); 
        printf("Data Saved on SD card.\n");
        
        ////////////Resetting flags and parameters///////
        
        finalsum=0;
        ac=0;
        mc=0;
        sum=0;
        f=0;
        good=0;
        bad=0;
        yes=0;
        no=0;
        ready=1;
        cflag=0;
        bf=0;
        msg1=0;
        }
 
    
    }
}