#include "mbed.h"

// First the inputs and pins are defined

AnalogIn flowIn(PA_0);
Serial co2(PC_10,PC_11);
AnalogIn sensor1(PC_0);
AnalogIn sensor2(PC_1);
AnalogIn sensor3(PC_2);
AnalogIn sensor4(PC_3);
AnalogIn sensor5(PA_4);
AnalogIn sensor6(PA_5);
AnalogIn sensor7(PA_6);
AnalogIn sensor8(PA_7);
AnalogIn temp(PA_1);

///////////////////// FLOW LOOP /////////////////////////
float finalflow;
float flowVal1;
float flowVal2;
float P1;
int flag=0;
int o=0;
float bpArray[10];
float fp;float sp;
float FPressure;
float flow()
{
    while(1) 
    {
        wait(0.01);
        flowVal1=3.3*flowIn; //Logic level 3.3
        flowVal2 = 1.5*flowVal1; //5v
        P1 =(125*flowVal2)-62.5; //Pressure
        //making the value of pressure positive inside the SQRT function:
        if(flag==0)
        {
            finalflow=0;
            bpArray[o]=P1;  
            sp+=bpArray[o];
            o=o+1;
                    if (o=9)
                    {
                        fp=sp/10;
                        flag=1;
                    }            
        }
        if (flag==1)
        {
            FPressure=P1-fp;
          finalflow=(0.24*sqrt(FPressure)); //flow in litter per second
          return finalflow;
        }
    }
}

///////////////////// CO2 LOOP /////////////////////////
int value;
float carbon()
{
    bool allow = false;
    char c;
    char co2_measure[5];
    int count=0;

    while(1) 
    {
        c = co2.getc();
        //based on the user manual PDF for the CO2 sensor, the value starts with "Z"
        //and we need to extract the right number of CO2 value
        if(c=='Z') {
            allow = true;
        }

        if(allow) {
            if(c>=48 && c<=57) {
                co2_measure[count]=c;
                count++;
            }
        
            if(count>=6) { 
                value = ((co2_measure[0]-'0')*100000+co2_measure[1]-'0')*10000+(co2_measure[2]-'0')*1000+(co2_measure[3]-'0')*100; 
                float CAR;
                CAR=(float)value/10000;
                count=0;
                allow=false;
                return CAR;
            }
        }
    }
}

///////////////////// TEMPERATURE LOOP /////////////////////////

float t2Cel;

float getTemp()
{
    while(1) {
        float B = 3478; //Define thermistor constant
        float rRef=10e3; // Define reference resistance
        float r1=10e3; // Define thermistor resistance at 25 C
        float t1=25+273; // Define thermistor initial temperature s 25C in Kelvin
        float x = temp.read(); //Measure input voltage at pin A0 in bits
        float v = 3.3*x; //Convert bits into voltage
        float r2 = (3.3*rRef/v)-rRef; //Convert voltage into thermistor resistance
        float t2 = (B*t1)/(B-t1*log(r1/r2)); //Convert thermistor resistance into temperature in Kelvin (log means natural logarithm ln)
        t2Cel = t2-273; //Convert temperature from Kelvin to Celcius
        return t2Cel;
//  printf("Temp: %f\n", t2Cel);
    }
}

///////////////////// 8-CHANNEL SENSOR LOOP /////////////////////////

float s1()
{
    float sen1;
    while(1){
            sen1=sensor1*3.3;
            return sen1;
            }
}
float s2()
{
    float sen2;
    while(1){
            sen2=sensor2*3.3;
            return sen2;
            }
}
float s3()
{
    float sen3;
    while(1){
            sen3=sensor3*3.3;
            return sen3;
            }
}
float s4()
{
    float sen4;
    while(1){
            sen4=sensor4*3.3;
            return sen4;
            }
}
float s5()
{
        float sen5;
        while(1){
                sen5=sensor5*3.3;
                return sen5;
                }
}
float s6()
{
        float sen6;
        while(1){
                sen6=sensor6*3.3;
                return sen6;
                }
}
float s7()
{
        float sen7;
        while(1){
                sen7=sensor7*3.3;
                return sen7;
                }
}
float s8()
{
        float sen8;
        while(1){
                sen8=sensor8*3.3;
                return sen8;
                }
}