#include "mbed.h"
#include "flow.h"


AnalogIn temp(PC_5);
Timer t;


Thread tempThread;
Thread stream;



 float t2Cel;
 
void getTemp(){
  while(1){
  float B = 3478; //Define thermistor constant
  float rRef=10e3; // Define reference resistance
  float r1=10e3; // Define thermistor resistance at 25 C
  float t1=25+273; // Define thermistor initial temperature s 25C in Kelvin
  float x = temp.read(); //Measure input voltage at pin A0 in bits
  float v = 3.3*x; //Convert bits into voltage
  float r2 = (3.3*rRef/v)-rRef; //Convert voltage into thermistor resistance
  float t2 = (B*t1)/(B-t1*log(r1/r2)); //Convert thermistor resistance into temperature in Kelvin (log means natural logarithm ln)
  t2Cel = t2-273; //Convert temperature from Kelvin to Celcius
//  printf("Temp: %f\n", t2Cel);
}
}

void data_thread() {
    while (true) {
        ttl.printf("Flow: %f, CO2: %d\n", flow(), carbon());
    }
}

int main()
{      
ttl.baud(9600);
    int delta;
    int myArray[9];
    long double var=0.0;
    float sigma=0.0;
    unsigned int sum=0;
    int difSum=0;
    int avg=0;
    unsigned long long sqSum=0;
    bool flag=false;
    bool flag2=false;
    
    
    tempThread.start(getTemp);
    stream.start(data_thread);
    flow();
    carbon();
    t.start();
    
    while(1){
  //  printf("CO2: %d, Flow: %f, Temp: %f\n", carbon(), flowVal, t2Cel);  //COOL TERM
////    printf("$d %f %f;", carbon(), flowVal, t2Cel); //Serial plotter
//    }
    
    //SOLENOID PART//
    //while(1){ 
     
    //}

  for(int i=0;i<9;i++){  //Get first 9 carbon values
      myArray[i]=carbon();
      ttl.printf("%d ", myArray[i]);
  }
  
   ttl.printf("\n");
   
  while(flag!=true){
    for(int i=0;i<9;i++){ 
      sum+=myArray[i]; //Find sum
    }
    
    avg=sum/9;//find average
    
    ttl.printf("Avg: %d\n", avg);
    
    for(int i=0;i<9;i++){ 
      difSum+=(myArray[i]-avg)*(myArray[i]-avg); //Find sum of difference between value X and mean
    }
        
    var=difSum/9;
    sigma=sqrt(var);
    
    ttl.printf("Standard dev: %f\n", sigma);
    
    if(sigma>=0.02){ //Check against carbon plateau, if sd greater than plateau startPoint
        for(int x=0;x<8;x++){
          myArray[x]=myArray[x+1];  //Shift all carbon to left by 1
          ttl.printf("%d ", myArray[x]);
        }
        
        myArray[8]=carbon(); // get new carbon value in last array slot
        ttl.printf("%d\n", myArray[8]);

        sum=0;  //Reset variables
        sqSum=0;
        var=0;
        sigma=0;
        avg=0;
        difSum=0;
        
    }else{
      ttl.printf("TURN ON SOLENOID\n"); //Turn on second sensor
      flag=true; //Terminate loop because sd is at plateau startPoint
    }
  }
  while(flag2!=true){
    for(int i=0;i<20;i++){  //Get first 9 carbon values
      myArray[i]=carbon();
      ttl.printf("%d ", myArray[i]);
  }  
      delta=myArray[20]-myArray[0];
      if(delta<0.05){
        for(int x=0;x<19;x++){
          myArray[x]=myArray[x+1];  //Shift all carbon to left by 1
          ttl.printf("%d ", myArray[x]);
        }
        
        myArray[19]=carbon(); // get new carbon value in last array slot
        ttl.printf("%d\n", myArray[19]);

        sum=0;  //Reset variables
        sqSum=0;
        var=0;
        sigma=0;
        avg=0;
        difSum=0;
        
    }else{
        
        ttl.printf("TURN OFF SOLENOID\n"); //Turn on second sensor
      flag2=true; //Terminate loop because sd is at plateau startPoint
    }
  }
  
}
}