#include "mbed.h"
#include "pressure.h"
#include "TextLCD.h"
#include "time.h"

/////////////////////////
// User has to hold his breath for 5 second at a correct amount of pressure
// There is an indicator on the LCD which shows the acceptable boundaries 
///////////////////////

//Serial ttl(PA_0, PA_1);
PwmOut led(PB_6);
TextLCD lcd(PC_8,PC_6,PB_15,PB_14,PB_13,PB_12, TextLCD::LCD16x2);
Timeout t;

int flag1;
float sample2=0;
float sample1;
float delta;
float sample0;
float delta2;
float sample3;
float sample4;
float delta3;
int error1;
int error2;
int U;

//  

void okmsg() {
    lcd.locate(6,0);
    lcd.printf("well done");
    flag1=0;
}  
       void one() {
       printf("1...\n");
       t.attach(&okmsg, 1.0);
       }
       void two() {
    lcd.locate(6,0);
    lcd.printf("hold: 2s ");
       t.attach(&one, 1.0);
       }
        void three() {
       lcd.locate(6,0);
    lcd.printf("hold: 3s ");
       t.attach(&two, 1.0);
       }
       void four() {
       lcd.locate(6,0);
    lcd.printf("hold: 4s ");
       t.attach(&three, 1.0);
       }
        void five() {
       lcd.locate(6,0);
    lcd.printf("hold: 5s ");
       t.attach(&four, 1.0);
       }
         void six() {
       lcd.locate(6,0);
    lcd.printf("hold: 6s ");
       t.attach(&five, 1.0);
       }

   void counting() {
    six();
}     

void RED1() {
            
// At the "Situation 0", which is before breathing into the device, 
// we reset everything and ask user to start breathing, set the brightness
// of the LED to the lowest, and detach the timer

            sample0=0;
            sample2=0;
            sample1=0;
            sample4=0;
            error1=0;
            error2=0;
            flag1=0;
            U=0;
            lcd.locate(0,1);
            lcd.printf("Start Breathing ");
            led.write(0.20f);
            t.detach();
                }
                
    void Harder(){
        if (delta2>0 and error1==0) 
        {
                t.detach();
                sample0=0;
                sample2=0;
                sample1=0;
                error1=1; 
                U=1; //This means that the program is now ready to have the breath in the standard boundaries.
         }
                }
 



int main()
{  

    pressure();
    flow();
    //ttl.baud(9600);
    //first we clear lcd
    lcd.cls();
    //then we define the location to start showing characters from there
    lcd.locate(2,0);    //column [0 to 15] , row [0,1] : in first row at the 2nd column I put the first line,
    lcd.printf("|");    //to show the first acceptable boundary.
    lcd.locate(3,0);    //in the same row, 3rd column, I put the second boundary.
    lcd.printf("|");
    //lcd.locate(0,1);
    //lcd.printf("breathe");
    
   int ft=0;
    while(1) {
     
     //lcd.locate(8,0);
   printf("f: %3.2f\n", flow());
     
       // ttl.printf("flow: %f\n", flow());
       
       //we're making comparasion using pressure because it was more reliable than flow
       
        //////////////////       SITUATION 0: Before Breathing
        if (pressure()<180.32)
        {
            //calls the following funtion which is defined before the main while loop:
            RED1();
        }
        
        
        //////////////////       SITUATION 1: Starts Breathing
        if (pressure()>=180.32 and pressure()<200)
        {
            sample0=pressure();
            delta2=sample1-sample0;
        //Naturally, at the beginning, the breath level goes to the situation 1 before situation 2
        //so we need to enable a flag called U at the following called function
        //so it means that the code is ready for the next stage:
            Harder();
            lcd.locate(0,1);
            lcd.printf("** OK           ");
            led.write(0.20f);
        }
        
        //////////////////       SITUATION 2: Standard level
        if (pressure()>=200 and pressure()<208.44)
        {
            sample1=pressure();
           delta=sample2-sample1;
           
        //If breath level has already reached the previous situation and now is in this situation,
        //then it is in a standard level and user has to keep it for 5 seconds
      
           if (U==1){
               //the following function activates a series of 7 other functions respectively.
               counting();
               U=0;
               }
           if (flag1==0 and delta < 0)
                {
                    flag1=1; 
                    //the following function activates a series of 7 other functions respectively.   
                    counting(); 
                }
            lcd.locate(0,1);
            lcd.printf("***  Good      ");
            led.write(0.40f);
        }
    
        //////////////////       SITUATION 3: Perfect level
        if (pressure()>=208.44 and pressure()<238.48)
        {
            lcd.locate(0,1);
            lcd.printf("**** Perfect    ");
            led.write(0.60f);
            sample2=pressure();
        }

        //////////////////       SITUATION 4: Standard level
        if (pressure()>=238.248 and pressure()<270.55)
        {
            sample3=pressure();
           delta3=sample4-sample3;
           if(delta3>0){
            counting();
            sample4=0;
            }
            lcd.locate(0,1);
            lcd.printf("***** Good      ");
            led.write(0.80f);
        }

        //////////////////       SITUATION 5: Too hard level
        if (pressure()>=270.55)
        {
            sample4=pressure();
            if (error2==0){
            sample0=0;
            sample2=0;
            sample1=0;    
            t.detach();
            error2=1; 
            }
            lcd.locate(0,1);
            lcd.printf("Breathe softer  ");
            led.write(1.00f);
        }
   // lcd.printf("%f\n", flow());
    wait (0.1);
                
    }
}
